*====================================================================
* This demo shows you the power of API programming and a number of
* structures and how to use them. It prints a rotated text and 
* several lines on the printer. Imagine, by using the API functions
* you have total control over the printer, you can print any reports
* you want, not just what the report writers offers.
*====================================================================

	#INCLUDE ApiDef.H
	
	*-----------------------------------------------------------------
	* Declare API function and load libraries
	*-----------------------------------------------------------------
	Set ClassLib to Struct, WinStruct Additive
	Do ApiDef
	
	*-----------------------------------------------------------------
	* First, we need the printer 
	*-----------------------------------------------------------------
	Local lcPrinter
	lcPrinter = GetPrinter()
	If Empty( m.lcPrinter )
		Return
	Endif
	
	*-----------------------------------------------------------------
	* In Windows, printing and displaying is always done via a 
	* device context (DC). The device context determines where to 
	* print as well as which driver to use, etc.
	*-----------------------------------------------------------------
	Local HDC
	HDC = CreateDC( "WINSPOOL", m.lcPrinter, NULL, NULL )
	If m.HDC == 0
		Return
	Endif
	
	*-----------------------------------------------------------------
	* Windows is document centered. That means you have to tell 
	* Windows that you want to start a new document. A document is the
	* same as a print job. StartDoc() requires a DOCINFO structure
	* that defines how the print job is displayed in the printer
	* job list.
	*-----------------------------------------------------------------
	Local loDocInfo, lnJobID
	loDocInfo = CreateObject( "DOCINFO" )
	With loDocInfo
		.cbSize = .SizeOf()
		.lpszDocName = "Struct demonstration document"
	Endwith
	lnJobID = StartDoc( m.HDC, loDocInfo.GetString() )
	
	*-----------------------------------------------------------------
	* Starting a print job doesn't mean you started a page...
	*-----------------------------------------------------------------
	StartPage( m.HDC )
	
	*-----------------------------------------------------------------
	* We print some lines. In order to position the lines properly we
	* need to know the size of the paper in pixels.
	*-----------------------------------------------------------------
	Local lnWidth, lnHeight
	lnWidth = GetDeviceCaps( m.HDC, HORZRES )
	lnHeight = GetDeviceCaps( m.HDC, VERTRES )
	
	*-----------------------------------------------------------------
	* And print a line pattern. In your application you can insert 
	* here the code to print something more useful. MoveToEx() sets
	* the cursor position, LineTo() prints a line fromt he current
	* cursor position to the give position.
	*-----------------------------------------------------------------
	Local lnPos
	For lnPos = 0 to m.lnWidth/2 Step 20
		MoveToEx( m.HDC, 0, m.lnPos, NULL )
		LineTo( m.HDC, (m.lnWidth/2) - m.lnPos, 0 )
	Endfor
	For lnPos = 0 to m.lnWidth/2 Step 20
		MoveToEx( m.HDC, m.lnWidth, m.lnPos, NULL )
		LineTo( m.HDC, (m.lnWidth/2) + m.lnPos, 0 )
	Endfor

	*-----------------------------------------------------------------
	* Now we display some rotated text. The CreateFontIndirect() API
	* function can do this for us. It returns a font handle that
	* represents a GDI object. Check out knowledgebase article
	* Q154515 to see some Visual Basic source code that does the same.
	* As you can see, VFP and VB look quite similar using the struct
	* component.
	*-----------------------------------------------------------------
	Local loFont, hFont
	loFont = CreateObject( "LOGFONT" )
	With loFont
		.lfEscapement = 450                               && 45 degrees
		.lfFaceName = "Arial"
		.lfHeight = -MulDiv( 36, GetDeviceCaps(m.HDC,LOGPIXELSY), 72 )
	Endwith
	hFont = CreateFontIndirect( loFont.GetString() )
	
	*-----------------------------------------------------------------
	* Activate the rotated forn and print some text. It's printed
	* within the line pattern, we painted before. The positions are
	* relative to the size of the document.
	*-----------------------------------------------------------------
	Local hPrevFont, lcText, lnX, lnY
	lcText = "Structures!"
	lnX = 0.02 * m.lnWidth
	lnY = 0.40 * m.lnWidth
	hPrevFont = SelectObject( m.HDC, m.hFont )
	TextOut( m.HDC, m.lnX, m.lnY, m.lcText, Len(m.lcText) )
	
	*-----------------------------------------------------------------
	* After we printed the text, we restore the current font to the
	* previously selected font and delete our rotated font.
	*-----------------------------------------------------------------
	SelectObject( m.HDC, m.hPrevFont )
	DeleteObject( m.hFont )

	*-----------------------------------------------------------------
	* Now we repeat the same for different positions and degrees. But
	* this time we display the background transparent. SetBkMode() 
	* changes the background to transparent or opaque.
	*-----------------------------------------------------------------
	Local lnDegree, hFont, hPrevFont, lnPrevMode
	lnPrevMode = SetBkMode( m.HDC, TRANSPARENT )
	For lnDegree = 0 to 3600 step 300
		loFont.lfEscapement = m.lnDegree
		hFont = CreateFontIndirect( loFont.GetString() )
		hPrevFont = SelectObject( m.HDC, m.hFont )
		TextOut( ;
			m.HDC, ;
			0.60 * m.lnWidth, ;
			0.40 * m.lnWidth, ;
			m.lcText, ;
			Len(m.lcText) ;
		)
		DeleteObject( m.hFont )
		SelectObject( m.HDC, m.hPrevFont )
	Endfor
	SetBkMode( m.HDC, m.lnPrevMode )

	*-----------------------------------------------------------------
	* To start printing you need to tell Windows that you finished the
	* document.
	*-----------------------------------------------------------------
	EndPage( m.HDC )
	EndDoc( m.HDC )
		
	*-----------------------------------------------------------------
	* In order to avoid memory leaks, we have to delete the DC after
	* printing.
	*-----------------------------------------------------------------
	DeleteDC( m.HDC )
	
