*====================================================================
* This procedure file contains additional functions that can be used
* for API programming. This includes for example getting a HWND to
* a form.
*
* written by The Foxpert!, 1999. Placed into Public Domain.
* 
*====================================================================


*====================================================================
* This function receives a reference to a form and returns the HWND
* (window handle) of this window. This lets you call all functions
* that require such a handle.
*====================================================================
Procedure APIGetHWND
LParameter toForm

	*-----------------------------------------------------------------
	* We identify a form with its caption. In order to get an exact
	* match we temporarily change the form's caption.
	*-----------------------------------------------------------------
	Local lcCaption
	lcCaption = toForm.Caption
	toForm.Caption = Sys(3)
	
	*-----------------------------------------------------------------
	* Getting the window handle is part of a FoxTools function.
	*-----------------------------------------------------------------
	If not "FOXTOOLS" $ Upper( Set("Library") )
		Set Library to (Home()+"\FoxTools.Fll") Additive
	Endif
	
	*-----------------------------------------------------------------
	* Get the HWND window handle
	*-----------------------------------------------------------------
	Local lnHWND
	lnHWND = _WhToHwnd( _WFindTitl(toForm.Caption) )
	
	*-----------------------------------------------------------------
	* Restore previous caption
	*-----------------------------------------------------------------
	toForm.Caption = m.lcCaption	
	
Return m.lnHWND
