*!*	********************************************
*!*	 Some quick tests I wrote while developing
*!*	 the JSON library will need some specific unit test prgs created
*!*	 and may use the webbrowser or script control to
*!*	 to run against json2.js during tests, but for now this will do
*!*	********************************************
*!*	 Just for the record, I've also run the JSON produced through some
*!*	 online validators and they indicate that the JSON this library
*!*	 produces from loJSON.Stringify() is valid
*!*	********************************************

CLEAR
CLOSE DATABASES ALL
CLEAR ALL
SET ESCAPE ON

LOCAL loJSON as JSON, lcClasslibWas
LOCAL loObjectIn, loCollectionIn, lcStringIn, llLogicalIn
LOCAL lnIntegerIn, lnNumericIn, ltDatetimeIn, ldDateIn
LOCAL lvNullIn
LOCAL ARRAY laFlatArrayIn(10), laMultiArrayIn(2,5)

LOCAL lcObjectJSON, lcCollectionJSON, lcStringJSON, lcLogicalJSON
LOCAL lcIntegerJSON, lnNumericJSON, lcDatetimeJSON, lcDateJSON
LOCAL lcNullJSON, lcFlatArrayJSON, lcMultiArrayJSON, lcCursorJSON

LOCAL loObjectOut, loCollectionOut, lcStringOut, llLogicalOut
LOCAL lnIntegerOut, lnNumericOut, ltDatetimeOut, ldDateOut
LOCAL lvNullOut
LOCAL ARRAY laFlatArrayOut(1), laMultiArrayOut(1)
m.lcClasslibWas = SET("Classlib")
SET CLASSLIB TO (LOCFILE("JSON.VCX", "VCX", "Locate JSON Class Library")) additive
m.loObjectIn = CREATEOBJECT("form")
m.loCollectionIn = CREATEOBJECT("collection")
m.loCollectionIn.Add(m.loObjectIn)
m.loCollectionIn.Add(m.loObjectIn)
m.loCollectionIn.Add(m.loObjectIn)
m.lcStringIn = "Testing String 1\t " + CHR(25) + CHR(9) + "dlfkh3o598y2305yndvbna05*&$%$)()@*$"
m.llLogicalIn = .T.
m.lnIntegerIn = 1
m.lnNumericIn = 1.1231452424
m.ltDatetimeIn = DATETIME()
m.ldDateIn = DATE()
m.lvNullIn = NULL
STORE "Testing 1" TO laFlatArrayIn
STORE "Testing 2" TO laMultiArrayIn

CREATE CURSOR crsCursorIn (field1 C(25), field2 L, field3 I, ;
	field4 N(10,2), field5 T, field6 D)
FOR m.lnRecordCounter = 1 TO 100 && a couple hundred records for now, seems fast
	INSERT INTO crsCursorIn VALUES ("Testing Cursor 1", .T., 1, ;
		1.1231452424, DATETIME(), DATE())
	INSERT INTO crsCursorIn VALUES ("Testing Cursor 2", .F., 2, ;
		2.1231452424, DATETIME(), DATE())
ENDFOR
m.loJSON = CREATEOBJECT("JSON")
m.loJSON.TrimStrings = .F.

FOR m.lnCounter = 1 TO 2
	m.loJSON.ParseRespectClass = (m.lnCounter = 1) && run tests twice, ParseRespectClass = .T. then = .F.
	m.loJSON.ParseDateType = IIF(m.lnCounter = 1, 1, 3)
	? "Running Tests ParseRespectClass = " + TRANSFORM(m.loJSON.ParseRespectClass)
	m.lcObjectJSON = m.loJSON.Stringify(m.loObjectIn, null, CHR(9))
	m.lcCollectionJSON = m.loJSON.Stringify(m.loCollectionIn, null, CHR(9))
	m.lcStringJSON = m.loJSON.Stringify(m.lcStringIn)
	m.lcLogicalJSON = m.loJSON.Stringify(m.llLogicalIn)
	m.lcIntegerJSON = m.loJSON.Stringify(m.lnIntegerIn)
	m.lnNumericJSON = m.loJSON.Stringify(m.lnNumericIn)
	m.lcDatetimeJSON = m.loJSON.Stringify(m.ltDatetimeIn)
	m.lcDateJSON = m.loJSON.Stringify(m.ldDateIn)
	m.lcNullJSON = m.loJSON.Stringify(m.lvNullIn)
	m.lcFlatArrayJSON = m.loJSON.Stringify(@m.laFlatArrayIn)
	m.lcMultiArrayJSON = m.loJSON.Stringify(@m.laMultiArrayIn)
	m.lcCursorJSON = m.loJSON.Stringify("crsCursorIn")
	m.loObjectOut = m.loJSON.Parse(m.lcObjectJSON)
	m.loCollectionOut = m.loJSON.Parse(m.lcCollectionJSON)
	m.lcStringOut = m.loJSON.Parse(m.lcStringJSON)
	m.llLogicalOut = m.loJSON.Parse(m.lcLogicalJSON)
	m.lnIntegerOut = m.loJSON.Parse(m.lcIntegerJSON)
	m.lnNumericOut = m.loJSON.Parse(m.lnNumericJSON)
	m.ltDatetimeOut = m.loJSON.Parse(m.lcDatetimeJSON)
	m.ldDateOut = m.loJSON.Parse(m.lcDateJSON)
	m.lvNullOut = m.loJSON.Parse(m.lcNullJSON)
	m.FlatReturn = m.loJSON.Parse(m.lcFlatArrayJSON, NULL, @m.laFlatArrayOut)
	m.MultiReturn = m.loJSON.Parse(m.lcMultiArrayJSON, NULL, @m.laMultiArrayOut)
	m.lcCursorAlias = m.loJSON.Parse(m.lcCursorJSON)

	? "String Test 1: " + GetTestStatus(m.lcStringOut == m.lcStringIn)
	? "Logical Test 1: " + GetTestStatus(m.llLogicalOut == m.llLogicalIn)
	? "Integer Test 1: " + GetTestStatus(m.lnIntegerOut == m.lnIntegerIn)
	? "Numeric Test 1: " + GetTestStatus(m.lnNumericOut == m.lnNumericIn)
	? "Datetime Test 1: " + GetTestStatus(m.ltDatetimeOut == m.ltDatetimeIn)
	? "Date Test 1: " + GetTestStatus(m.ldDateOut == m.ldDateIn)

	m.llObjectTest1Passed = (AMEMBERS(aPEMSIn, m.loObjectIn, 0) = AMEMBERS(aPEMSOut, m.loObjectOut, 0))
	? "Object Test 1: " + GetTestStatus(m.llObjectTest1Passed)

	m.llObjectTestPassed = .T.
	m.llObjectTest2Passed = .T.
	m.llObjectTest3Passed = .T.
	m.llFirstFail = .T.
	FOR m.lnPropCounter = 1 TO ALEN(aPEMSOut)
		m.lcTypeIn = TYPE("m.loObjectIn." + aPEMSIn(m.lnPropCounter))
		m.lcTypeOut = TYPE("m.loObjectOut." + aPEMSOut(m.lnPropCounter))
		IF !PEMSTATUS(m.loObjectIn, aPEMSIn(m.lnPropCounter), 1) OR !PEMSTATUS(m.loObjectOut, aPEMSOut(m.lnPropCounter), 1) && if property is readonly skip checking it's value (such as hwnd of form)
			m.lvValueIn = IIF(m.lcTypeIn = "U", "IS_NULL", EVALUATE("m.loObjectIn." + aPEMSIn(m.lnPropCounter)))
			m.lvValueOut = IIF(m.lcTypeOut = "U", "IS_NULL", EVALUATE("m.loObjectOut." + aPEMSOut(m.lnPropCounter)))
			TRY
				m.llObjectTest2Passed = m.llObjectTest2Passed AND (NVL(m.lvValueIn, "IS_NULL") == NVL(m.lvValueOut, "IS_NULL"))
			CATCH && datatype mismatch or something
				m.llObjectTest2Passed = .F.
			ENDTRY
		ENDIF
		m.llObjectTest3Passed = m.llObjectTest3Passed AND (aPEMSIn(m.lnPropCounter) = aPEMSOut(m.lnPropCounter))
		IF m.llFirstFail AND (!m.llObjectTest2Passed OR !m.llObjectTest3Passed)
			m.llFirstFail = .F.
			? "Failed on IN: " + aPEMSIn(m.lnPropCounter) + " OUT: " + aPEMSOut(m.lnPropCounter)
			EXIT
		ENDIF
	ENDFOR
	? "Object Test 2: " + GetTestStatus(m.llObjectTest2Passed)
	? "Object Test 3: " + GetTestStatus(m.llObjectTest3Passed)

	? "Flat Array Test 1: " + GetTestStatus(ALEN(m.laFlatArrayIn) == ALEN(m.laFlatArrayOut))
	m.lnRowsIn = ALEN(m.laFlatArrayIn, 1)
	m.lnColumnsIn = ALEN(laFlatArrayIn,2)
	? "Flat Array Test 2: " + GetTestStatus(m.lnRowsIn = ALEN(m.laFlatArrayOut, 1))
	? "Flat Array Test 3: " + GetTestStatus(m.lnColumnsIn = ALEN(laFlatArrayOut,2))

	m.llFirstFail = .T.
	m.llArrayTest4Passed = .T.
	FOR m.lnIndexCounter = 1 TO m.lnRowsIn
		m.llArrayTest4Passed = m.llArrayTest4Passed AND (NVL(m.laFlatArrayIn(m.lnIndexCounter), "IS_NULL") == NVL(m.laFlatArrayOut(m.lnIndexCounter), "IS_NULL"))
		IF m.llFirstFail AND !m.llArrayTest4Passed
			m.llFirstFail = .F.
			? "Failed on IN: " + m.laFlatArrayIn(m.lnIndexCounter) ;
				+ " OUT: " + m.laFlatArrayOut(m.lnIndexCounter) ;
				+ " INDEX: " + TRANSFORM(m.lnIndexCounter)
			EXIT
		ENDIF
	ENDFOR
	? "Flat Array Test 4: " + GetTestStatus(m.llArrayTest4Passed)

	? "Multi-Dim Array Test 1: " + GetTestStatus(ALEN(m.laMultiArrayIn) == ALEN(m.laMultiArrayOut))
	m.lnRowsIn = ALEN(m.laMultiArrayIn, 1)
	m.lnColumnsIn = ALEN(laMultiArrayIn,2)
	? "Multi-Dim Array Test 2: " + GetTestStatus(m.lnRowsIn = ALEN(m.laMultiArrayOut, 1))
	? "Multi-Dim Array Test 3: " + GetTestStatus(m.lnColumnsIn = ALEN(laMultiArrayOut,2))

	m.llFirstFail = .T.
	m.llArrayTest4Passed = .T.
	FOR m.lnRowCounter = 1 TO m.lnRowsIn
		FOR m.lnColumnCounter = 1 TO m.lnColumnsIn
			m.llArrayTest4Passed = m.llArrayTest4Passed AND (NVL(m.laMultiArrayIn(m.lnRowCounter, m.lnColumnCounter), "IS_NULL") == NVL(m.laMultiArrayOut(m.lnRowCounter, m.lnColumnCounter), "IS_NULL"))
			IF m.llFirstFail AND !m.llArrayTest4Passed
				m.llFirstFail = .F.
				? "Failed on IN: " + m.laMultiArrayIn(m.lnRowCounter, m.lnColumnCounter) ;
					+ " OUT: " + m.laMultiArrayOut(m.lnRowCounter, m.lnColumnCounter) ;
					+ " ROW: " + TRANSFORM(m.lnRowCounter) ;
					+ " COL: " + TRANSFORM(m.lnColumnCounter)

				EXIT
			ENDIF
		ENDFOR
	ENDFOR
	? "Multi-Dim Array Test 4: " + GetTestStatus(m.llArrayTest4Passed)

	IF USED("crsCursorIn") AND USED(m.lcCursorAlias)
		? "Cursor Test 1: " + GetTestStatus(.T.)
		SELECT crsCursorIN
		GO TOP IN "crsCursorIN"
		GO TOP IN (m.lcCursorAlias)
		? "Cursor Test 2: " + GetTestStatus(RECCOUNT("crsCursorIN") = RECCOUNT(m.lcCursorAlias))
		? "Cursor Test 3: " + GetTestStatus(AFIELDS(aFieldsIn, "crsCursorIN") = AFIELDS(aFieldsOut, m.lcCursorAlias))
		m.llFirstFail = .T.
		m.llCursorTest4Passed = .T.
		DO WHILE !EOF("crsCursorIN")
			FOR m.lnFieldCounter = 1 TO ALEN(aFieldsIn,1)
				m.llCursorTest4Passed = m.llCursorTest4Passed ;
										AND NVL(EVALUATE("crsCursorIN." + aFieldsIn(m.lnFieldCounter, 1)), "IS_NULL") ;
										==  NVL(EVALUATE(m.lcCursorAlias + "." + aFieldsOut(m.lnFieldCounter, 1)), "IS_NULL")
				IF m.llFirstFail AND !m.llCursorTest4Passed
					m.llFirstFail = .F.
					? "Failed on IN: " + m.aFieldsIn(m.lnFieldCounter, 1) ;
						+ " OUT: " + m.aFieldsOut(m.lnFieldCounter, 1) ;
						+ " RECORD: " + TRANSFORM(RECNO("crsCursorIN"))
					EXIT
				ENDIF
			ENDFOR
			SKIP 1 IN (m.lcCursorAlias)
			SKIP 1 IN ("crsCursorIN")
		ENDDO
		? "Cursor Test 4: " + GetTestStatus(m.llCursorTest4Passed)
	ELSE
		? "Cursor Test 1: " + GetTestStatus(.F.)
	ENDIF


	*!* If m.loJSON.ParseRespectClass = .F. then these tests will probably always fail
	*!* since the Items array is added to the object as it is serialized to JSON.
	*!* So, when it comes back out it will have an additional property holding the items.
	*!* Could add test code to test loCollectionOut.Items vs the items in the collection loCollectionIn,
	*!* but I've already verified that it works and I am too lazy right now. <g>
	IF m.loJSON.ParseRespectClass = .F.
		? "Expected Failures to Follow: (see code comments)"
	ENDIF
	m.llCollectionTest1Passed = (AMEMBERS(aPEMSIn, m.loCollectionIn, 0) = AMEMBERS(aPEMSOut, m.loCollectionOut, 0))
	? "Collection Test 1: " + GetTestStatus(m.llCollectionTest1Passed)
	m.llCollectionTestPassed = .T.
	m.llCollectionTest2Passed = .T.
	m.llCollectionTest3Passed = .T.
	m.llFirstFail = .T.
	FOR m.lnPropCounter = 1 TO ALEN(aPEMSOut)
		m.lcTypeIn = TYPE("m.loCollectionIn." + aPEMSIn(m.lnPropCounter))
		m.lcTypeOut = TYPE("m.loCollectionOut." + aPEMSOut(m.lnPropCounter))
		m.lvValueIn = IIF(m.lcTypeIn = "U", "IS_NULL", EVALUATE("m.loCollectionIn." + aPEMSIn(m.lnPropCounter)))
		m.lvValueOut = IIF(m.lcTypeOut = "U", "IS_NULL", EVALUATE("m.loCollectionOut." + aPEMSOut(m.lnPropCounter)))
		TRY
			m.llCollectionTest2Passed = m.llCollectionTest2Passed AND (NVL(m.lvValueIn, "IS_NULL") == NVL(m.lvValueOut, "IS_NULL"))
		CATCH && datatype mismatch or something
			m.llCollectionTest2Passed = .F.
		ENDTRY
		m.llCollectionTest3Passed = m.llCollectionTest3Passed AND (aPEMSIn(m.lnPropCounter) = aPEMSOut(m.lnPropCounter))
		IF m.llFirstFail AND (!m.llCollectionTest2Passed OR !m.llCollectionTest3Passed)
			m.llFirstFail = .F.
			? "Failed on IN: " + aPEMSIn(m.lnPropCounter) + " OUT: " + aPEMSOut(m.lnPropCounter)
			EXIT
		ENDIF
	ENDFOR
	? "Collection Test 2: " + GetTestStatus(m.llCollectionTest2Passed)
	? "Collection Test 3: " + GetTestStatus(m.llCollectionTest3Passed)
	?
	?
ENDFOR
SET CLASSLIB TO &lcClasslibWas
RETURN

FUNCTION GetTestStatus(tlPassed)
	RETURN IIF(m.tlPassed, "*PASSED*", "*FAILED*")
ENDFUNC

*!* Some Datetimes may fail the following tests when UseUTCDateTime = .T.
*!* This does not necessarily mean that the library has a bug in it.
*!* Remember that when springing forward for Daylight Saving there is
*!* an hour (or whatever the bias is for your locale) missing, so converting from
*!* that Datetime to UTC produces ambiguous results. And, when falling
*!* back to Standard times within that hour (or whatever the bias is for your locale)
*!* happens twice.
CLEAR
SET CLASSLIB TO LOCFILE("json.vcx","VCX","Locate JSON Library")
oJSON = CREATEOBJECT("JSON")
oJSON.ParseDatetype = 3
m.ldEpoch = DTOT(DATE(1970,1,1))
m.ldDateTimeToTest = m.ldEpoch
FOR m.lnCounter = 0 TO 36000000 STEP 3600
	m.ldDateTimeToTest = (m.ldEpoch + m.lnCounter)
	oJSON.UseUTCDateTime = .T.
	m.lcDatetime1 = oJSON.Stringify(m.ldDateTimeToTest)
	m.ldParsed1 = oJSON.Parse(m.lcDatetime1)
	IF m.ldParsed1 != m.ldDateTimeToTest
		? "UseUTCDateTime = .T. Failed on: " + TTOC(m.ldDateTimeToTest)
		? "Result was: " + TTOC(m.ldParsed1)
	ENDIF
	oJSON.UseUTCDateTime = .F.
	m.lcDatetime2 = oJSON.Stringify(m.ldDateTimeToTest)
	m.ldParsed2 = oJSON.Parse(m.lcDatetime2)
	IF m.ldParsed2 != m.ldDateTimeToTest
		? "UseUTCDateTime = .F. Failed on: " + TTOC(m.ldDateTimeToTest)
		? "Result was: " + TTOC(m.ldParsed2)
	ENDIF
ENDFOR
? "Last Date Processed: " + TTOC(m.ldDateTimeToTest)
SET CLASSLIB TO 
RETURN

*!* Additional tests for Standard vs. Daylight Savings (CST shown below - change datetimes for your locale)
CLEAR
SET CLASSLIB TO LOCFILE("json.vcx","VCX","Locate JSON Library")
oJSON = CREATEOBJECT("JSON")
oJSON.ParseDatetype = 3
? "UseUTCDateTime = .T."
oJSON.UseUTCDateTime = .T.
lcDatetime5 = oJSON.Stringify( {^2008-11-02 02:00:00} )
lcDatetime6 = oJSON.Stringify( {^2008-11-02 01:59:59} )
?"Stringify: " + lcDatetime5
?"Parse: "
??oJSON.Parse(m.lcDatetime5)
?"Stringify: " + lcDatetime6
?"Parse: "
??oJSON.Parse(m.lcDatetime6)
?
? "UseUTCDateTime = .F."
oJSON.UseUTCDateTime = .F.
lcDatetime5 = oJSON.Stringify( {^2008-11-02 02:00:00} )
lcDatetime6 = oJSON.Stringify( {^2008-11-02 01:59:59} )
?"Stringify: " + lcDatetime5
?"Parse: "
??oJSON.Parse(m.lcDatetime5)
?"Stringify: " + lcDatetime6
?"Parse: "
??oJSON.Parse(m.lcDatetime6)
?
? "UseUTCDateTime = .T."
oJSON.UseUTCDateTime = .T.
lcDatetime7 = oJSON.Stringify( {^2008-03-09 03:00:00} )
lcDatetime8 = oJSON.Stringify( {^2008-03-09 01:59:59} )
?"Stringify: " + lcDatetime7
?"Parse: "
??oJSON.Parse(m.lcDatetime7)
?"Stringify: " + lcDatetime8
?"Parse: "
??oJSON.Parse(m.lcDatetime8)
?
? "UseUTCDateTime = .F."
oJSON.UseUTCDateTime = .F.
lcDatetime7 = oJSON.Stringify( {^2008-03-09 03:00:00} )
lcDatetime8 = oJSON.Stringify( {^2008-03-09 01:59:59} )
?"Stringify: " + lcDatetime7
?"Parse: "
??oJSON.Parse(m.lcDatetime7)
?"Stringify: " + lcDatetime8
?"Parse: "
??oJSON.Parse(m.lcDatetime8)
?
SET CLASSLIB TO 
