*========================================================================================
* Access the Google Docs API
*========================================================================================

	*--------------------------------------------------------------------------------------
	* Manage external dependencies.
	*--------------------------------------------------------------------------------------
	Set Library To Json/Json.fll	
	Set Safety off
	
	*--------------------------------------------------------------------------------------
	* OAuth 2.0 configuration
	*--------------------------------------------------------------------------------------
	Local loOAuth2
	loOAuth2 = NewObject("GoogleOAuth2", "GoogleOAuth2.prg")
	loOAuth2.cClientId = "733013890517.apps.googleusercontent.com"
	loOAuth2.cClientSecret = "uhBzCDBQalirA8udnaAKtHel"
	loOAuth2.cScope = "https://docs.google.com/feeds/"

	*--------------------------------------------------------------------------------------
	* Accessing the Document list
	*--------------------------------------------------------------------------------------
	Local loHttp, lcDocs
	loHttp = NewObject ("CHttpClient", "cHttpClient.prg")
	loHttp.UseSsl()
	If loHttp.Connect ("docs.google.com")
		loHttp.cHeaders = "" ;
			+"GData-Version: 3.0" + Chr(13)+Chr(10) ;
			+"Authorization: Bearer " + loOAuth2.GetAccessToken ()
		lcDocs = loHttp.Get ("https://docs.google.com/feeds/default/private/full")
	EndIf
	
	StrToFile(Strtran(m.lcDocs, "><", ">"+Chr(13)+Chr(10)+"<"), "docs.xml")
	Modify File docs.xml

	*--------------------------------------------------------------------------------------
	* We parse documents into a cursor
	*--------------------------------------------------------------------------------------
	Create Cursor Docs ( ;
		 Name V(250) ;
		,Updated T;
		,Type V(50) ;
		,Link M ;
		,Edit M;
		,Rel M ;
	) 
	
	*--------------------------------------------------------------------------------------
	* Initialize namespaces on the XML parser.
	*--------------------------------------------------------------------------------------
	Local loXml
	loXml = NewObject("CXmlParser", "CXmlParser.prg")
	loXml.setnamespaces( "";
		+"xmlns:a='http://www.w3.org/2005/Atom' " ;
		+"xmlns:openSearch='http://a9.com/-/spec/opensearch/1.1/' " ;
		+"xmlns:docs='http://schemas.google.com/docs/2007' ";
		+"xmlns:batch='http://schemas.google.com/gdata/batch' " ;
		+"xmlns:gd='http://schemas.google.com/g/2005'" ;
	)

	*--------------------------------------------------------------------------------------
	* Parse entries into records.
	*--------------------------------------------------------------------------------------
	Local loNodes, loNode
 	loXml.Requery (m.lcDocs)
	loNodes = loXml.GetNodes("//a:entry")
	For each loNode in loNodes
		Insert into Docs Values ( ;
			 loXml.GetValue("a:title", m.loNode, "") ;
			,loXml.GetValue("a:updated", m.loNode, {/:}) ;
			,loXml.GetValue("a:content/@type", m.loNode, "") ;
			,loXml.GetValue("a:content/@src", m.loNode, "") ;
			,loXml.GetValue('a:link[@rel="edit"]/@href', m.loNode, "") ;
			,loXml.GetValue('a:link[@rel="resumable-edit-media"]/@href', m.loNode, "") ;
		)
	EndFor
	
	*--------------------------------------------------------------------------------------
	* Get the content of first document
	*--------------------------------------------------------------------------------------
	Local lcContent
	Go top
	loHttp.cHeaders = "" ;
		+"GData-Version: 3.0" + Chr(13)+Chr(10) ;
		+"Authorization: Bearer " + loOAuth2.GetAccessToken ()
	lcContent = loHttp.Get (Docs.Link)

	StrToFile(m.lcContent, "doc.html")

	*--------------------------------------------------------------------------------------
	* Create a new document entry
	*--------------------------------------------------------------------------------------
	Local lcEntry
	Text to m.lcEntry noshow pretext 2
		<?xml version="1.0" encoding="UTF-8"?>
		<entry xmlns="http://www.w3.org/2005/Atom" xmlns:docs="http://schemas.google.com/docs/2007">
		  <title>Sample document 2</title>
		</entry>
	EndText 
	Text to m.lcContent noshow pretext 2
		<html>
		  This page intentionally left blank.
		</html>
	EndText 

	*--------------------------------------------------------------------------------------
	* Retrieve reference to the resumable create media link.
	*--------------------------------------------------------------------------------------
	Local lcUrl, lcRel
	lcRel = "http://schemas.google.com/g/2005#resumable-create-media"
	lcUrl = loXml.GetValue ('/a:feed/a:link[@rel="'+m.lcRel+'"]/@href',NULL,"")

	*--------------------------------------------------------------------------------------
	* Initiate upload
	*--------------------------------------------------------------------------------------
	loHttp.cHeaders = "" ;
		+"GData-Version: 3.0" + Chr(13)+Chr(10) ;
		+"Authorization: Bearer " + loOAuth2.GetAccessToken () + Chr(13)+Chr(10) ;
		+"Content-Type: application/atom+xml" + Chr(13)+Chr(10) ;
		+"Content-Length: " + Transform(Len(m.lcEntry)) + Chr(13)+Chr(10) ;
		+"X-Upload-Content-Length: " + Transform(Len(m.lcContent)) + Chr(13)+Chr(10) ;
		+"X-Upload-Content-Type: text/html"
	loHttp.Post (m.lcUrl, m.lcEntry)
	
	*--------------------------------------------------------------------------------------
	* Send the actual content
	*--------------------------------------------------------------------------------------
	Local lcEntry
	loHttp.cHeaders = "" ;
		+"GData-Version: 3.0" + Chr(13)+Chr(10) ;
		+"Content-Length: " + Transform(Len(m.lcContent)) + Chr(13)+Chr(10) ;
		+"Content-Type: text/html" + Chr(13)+Chr(10) ;
		+"Content-Range: bytes 0-"+Transform(Len(m.lcContent)-1)+"/";
		+Transform(Len(m.lcContent))
	lcEntry = loHttp.Put (loHttp.cLocation, m.lcContent)

	StrToFile(Strtran(m.lcEntry, "><", ">"+Chr(13)+Chr(10)+"<"), "entry.xml")
