*========================================================================================
* XML Parser
*========================================================================================
Define Class CXMLParser as Custom

	oXML = NULL

*========================================================================================
* Es kann direkt beim CREATEOBJECT() ein XML String bergeben werden.
*========================================================================================
Procedure Init( tcXML )
	This.LoadParser()
	If not Empty(m.tcXML)
		This.Requery( m.tcXML )
	EndIf
EndProc

*========================================================================================
* Der XML Parser kann entweder mit einem XML String oder einem Dateinamen beladen werden.
*========================================================================================
Procedure Requery( tcXML )
	Local llOK
	If Left(m.tcXML,1) == "<"
		llOK = This.RequeryString(m.tcXML)
	Else
		llOK = This.RequeryFile(m.tcXML)
	EndIf 
Return m.llOK

*========================================================================================
* Laden des XML Parsers
*========================================================================================
Procedure LoadParser
	this.oXML = CREATEOBJECT("msXML2.domDocument.6.0")
	this.oXML.async = .f.
	this.oXML.ValidateOnParse = .f.
	this.oXML.SetProperty("SelectionLanguage", "XPath")
	this.oXML.SetProperty("NewParser", .t.)
EndProc

*========================================================================================
* Laden eines XML Strings
*========================================================================================
Procedure RequeryString( tcXML )
	Local llOK
	llOK = This.oXML.LoadXML( m.tcXML )
Return m.llOK

*========================================================================================
* Laden einer XML Datei
*========================================================================================
Procedure RequeryFile( tcFile )
	Local llOK
	llOK = This.oXML.Load( m.tcFile )
Return m.llOK


*========================================================================================
* Returns nodes in a collection. 
* 
* If tlResolveReferences is .T. and a node defines an href attribute, the reference node
* is replaced with the one it points to. Java web services frequently use MultiRef nodes
* to serialize linked objects.
*========================================================================================
Procedure GetNodes( tcQuery, toNode, tlResolveReferences )
	
	*--------------------------------------------------------------------------------------
	* Eine leere Collection erzeugen
	*--------------------------------------------------------------------------------------
	Local loCollection
	loCollection = CreateObject("Collection")
	
	*--------------------------------------------------------------------------------------
	* Die Abfrage kann entweder von einem Knoten oder dem Root aus erfolgen.
	*--------------------------------------------------------------------------------------
	Local loNode
	If Vartype(m.toNode) == "O"
		loNode = m.toNode
	Else
		loNode = this.oXML
	EndIf
	
	*--------------------------------------------------------------------------------------
	* Abfrage ausfhren und alle Knoten bernehmen
	*--------------------------------------------------------------------------------------
	Local loQuery, lnItem, loItem
	loQuery = loNode.selectNodes( m.tcQuery )
	For lnItem=1 to loQuery.length
		loItem = loQuery.item[m.lnItem-1]
		If tlResolveReferences
			loItem = This.HandleReferenceNode( m.loItem )
		EndIf
		loCollection.Add( m.loItem )
	EndFor
	
Return m.loCollection


*========================================================================================
* Checks if the current node is a reference to another node. In this case, the other node
* is returned.
*========================================================================================
Procedure HandleReferenceNode( toNode )

	*--------------------------------------------------------------------------------------
	* Check if the current node is a reference node
	*--------------------------------------------------------------------------------------
	Local lcRef
	lcRef = This.GetValue("@href",m.toNode)
	If Empty(m.lcRef)
		Return m.toNode
	EndIf
	
	*--------------------------------------------------------------------------------------
	* At this time we can only handle references that point to a location inside the 
	* document. These references start with "#"
	*--------------------------------------------------------------------------------------
	If Left(m.lcRef,1) == "#"
		lcRef = Substr(m.lcRef,2)
	EndIf
	
	*--------------------------------------------------------------------------------------
	* Locate the node with the specified ID
	*--------------------------------------------------------------------------------------
	Local loNode
	loNode = This.GetNode('//*[@id="'+m.lcRef+'"]')
	
Return m.loNode


*========================================================================================
* Returns a single node
*========================================================================================
Procedure GetNode( tcQuery, toNode )
	
	*--------------------------------------------------------------------------------------
	* Die Abfrage kann entweder von einem Knoten oder dem Root aus erfolgen.
	*--------------------------------------------------------------------------------------
	Local loNode
	If Vartype(m.toNode) == "O"
		loNode = m.toNode
	Else
		loNode = this.oXML
	EndIf
	
	*--------------------------------------------------------------------------------------
	* Abfrage ausfhren und alle Knoten bernehmen
	*--------------------------------------------------------------------------------------
	Local loResult
	loResult = loNode.selectSingleNode( m.tcQuery )
	
Return m.loResult


*========================================================================================
* Returns nodes in an array
*========================================================================================
Procedure AGetNodes( raNodes, tcQuery, toNode )
	
	*--------------------------------------------------------------------------------------
	* Die Abfrage kann entweder von einem Knoten oder dem Root aus erfolgen.
	*--------------------------------------------------------------------------------------
	Local loNode
	If Vartype(m.toNode) == "O"
		loNode = m.toNode
	Else
		loNode = this.oXML
	EndIf
	
	*--------------------------------------------------------------------------------------
	* Abfrage ausfhren und alle Knoten bernehmen
	*--------------------------------------------------------------------------------------
	Local loQuery, lnItem, lnCount
	loQuery = loNode.selectNodes( m.tcQuery )
	lnCount = loQuery.length
	If m.lnCount > 0
		Dimension raNodes[m.lnCount]
		For lnItem=1 to m.lnCount
			raNodes[m.lnItem] = loQuery.item[m.lnItem-1]
		EndFor
	EndIf 
	
Return m.lnCount



*========================================================================================
* Liefert das Ergebnis einer Abfrage
*========================================================================================
Procedure GetValue( tcQuery, toNode, tuDefault )

	*--------------------------------------------------------------------------------------
	* Die Abfrage kann entweder von einem Knoten oder dem Root aus erfolgen.
	*--------------------------------------------------------------------------------------
	Local loNode
	If Vartype(m.toNode) == "O"
		loNode = m.toNode
	Else
		loNode = this.oXML
	EndIf
	
	*--------------------------------------------------------------------------------------
	* Abfrage ausfhren
	*--------------------------------------------------------------------------------------
	Local loQuery
	loQuery = loNode.selectSingleNode( m.tcQuery )
	
	*--------------------------------------------------------------------------------------
	* Den Wert ermitteln
	*--------------------------------------------------------------------------------------
	Local lcValue
	lcValue = ""
	Do case
	
	*--------------------------------------------------------------------------------------
	* Der Wert konnte nicht gefunden werden
	*--------------------------------------------------------------------------------------
	Case IsNull(m.loQuery)
	
	*--------------------------------------------------------------------------------------
	* Es handelt sich um eine gewhnliche Node. Wir laden die erst Node, die nicht leer 
	* ist, um kein Problem bei Zeilenumbrchen zu haben.
	*--------------------------------------------------------------------------------------
	Case loQuery.NodeType == 1
		Local lnNode
		If loQuery.hasChildNodes
			For lnNode=0 to loQuery.childNodes.length-1
				lcValue =  Nvl(loQuery.childNodes[m.lnNode].nodeValue,"")
				If not Empty(m.lcValue)
					Exit
				EndIf
			EndFor
		EndIf 
	
	*--------------------------------------------------------------------------------------
	* Es handelt sich um einen Attributknoten
	*--------------------------------------------------------------------------------------
	Case loQuery.NodeType == 2
		lcValue = Nvl( loQuery.nodeValue, "" )
	
	*--------------------------------------------------------------------------------------
	* Es handelt sich um einen #TEXT Knoten
	*--------------------------------------------------------------------------------------
	Case loQuery.NodeType == 3
		lcValue = Nvl( loQuery.nodeValue, "" )
	EndCase 
	
	*--------------------------------------------------------------------------------------
	* If we have a default value, we use it to convert the value to a matching type.
	*--------------------------------------------------------------------------------------
	Local luValue
	If Pcount() == 3
		luValue = This.ConvertValue( m.lcValue, m.tuDefault )
	Else
		luValue = m.lcValue
	EndIf
	
Return m.luValue


*========================================================================================
* Converts a character value into a value of the specified type. If the value is empty,
* this function returns the default value.
*========================================================================================
Procedure ConvertValue( tcValue, tuDefault )

	*--------------------------------------------------------------------------------------
	* The conversion routine depends on the type.
	*--------------------------------------------------------------------------------------
	Local luValue, lcValue
	lcValue = m.tcValue
	DO case 

	*--------------------------------------------------------------------------------------
	* Boolean values can be stored as yes/no or true/false
	*--------------------------------------------------------------------------------------
	Case Vartype(m.tuDefault)  == "L"
		lcValue = Lower(Alltrim(m.lcValue))
		DO Case
		Case m.lcValue == "yes"
			luValue = .T.
		Case m.lcValue == "true"
			luValue = .T.
		Case m.lcValue == "no"
			luValue = .F.
		Case m.lcValue == "false"
			luValue = .F.
		Otherwise 
			luValue = m.tuDefault
		EndCase 
	
	*--------------------------------------------------------------------------------------
	* Numeric values
	*--------------------------------------------------------------------------------------
	Case Vartype(m.tuDefault) == "N"
		lcValue = Chrtran(m.lcValue,Chrtran(m.lcValue,"$-1234567890.+Ee",""),"")
		luValue = &lcValue
		If Vartype(m.luValue) == "Y"
			luValue = Mton(m.luValue)
		EndIf 
	
	*--------------------------------------------------------------------------------------
	* We always remove blanks surrounding strings
	*--------------------------------------------------------------------------------------
	Case Vartype(m.tuDefault) == "C"
		luValue = Alltrim(m.lcValue)
	
	*--------------------------------------------------------------------------------------
	* VFP 9 handles XSD datetime values properly
	*--------------------------------------------------------------------------------------
	Case Vartype(m.tuDefault) == "T"
		luValue = Ctot(m.lcValue)
	
	*--------------------------------------------------------------------------------------
	* Ohter data types aren't supported.
	*--------------------------------------------------------------------------------------
	Otherwise 
		luValue = .F.
	EndCase 

Return m.luValue


*========================================================================================
* Liefert den Namen eines Knotens zurck.
*========================================================================================
Procedure GetName( toNode )
	Local lcName
	m.lcName = toNode.nodeName
Return m.lcName


*========================================================================================
* Most ActiveX controls use Unicode instead of ANSI. Since VFP isn't Unicode compatible,
* it supports UTF-8 for ActiveX controls.
*========================================================================================
Procedure SetCharset( tcCharset )

	Do case
	Case Upper(Alltrim(m.tcCharset)) == "UTF-8"
		Comprop( This.oXML, "UTF8", 1 )
	Case Upper(Alltrim(m.tcCharset)) == "ANSI"
		Comprop( This.oXML, "UTF8", 0 )
	EndCase

EndProc

*========================================================================================
* 
*========================================================================================
Procedure SetNamespaces( tcNamespaces )

	This.oXML.setProperty( "SelectionNamespaces", m.tcNamespaces )

EndProc

EndDefine