* Preparations to load data from a table from VFP
SET POINT TO "."
LOCAL placeholderForData
placeholderForData = loadDataFromVFP ()		&& function see below

*  I. Insert the code to create charts as a javascript function
*     into the <head> section.
* II. Put a <div> for every chart into the <body> section

*!*	Step 1: Load the Google API and the packages you need
*!*	Step 2: Set a callback; function drawChart is written by you
*!*	Step 3: Define a function that creates and populates a data table, 
*!*					instantiates the chart, passes in the data and draws it
*!*	Step 4: Variable named data contains data
*!*			4a: Create the variable data: It's a DataTable
*!*			4b: Define columns
*!*			4c: Fill rows with data
*!*	Step 5: Draw a pie chart
*!*			5a: Set chart options
*!*			5b: Instantiate the chart
*!*			5c: Draw the chart
*!*	Step 6: Draw a bar chart (like step 5)
*!*	Step 7: Show list of entries in data
*!*	Step 8: Show gauges, only for columns 1 and 2
*!*	Step 9: A motion chart (see notes concerning Flash below)

	** Start
LOCAL htmlResult
TEXT TO m.htmlResult TEXTMERGE NOSHOW

<html>
	<head>
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript">
			
			/* Step 1: Load the Google API and the packages you need */
			google.load('visualization', '1', 
			  {'packages': ['corechart', 'table', 'gauge', 'motionchart']});
			
			/* Step 2: Set a callback; function drawChart is written by you */
			google.setOnLoadCallback(drawChart);
      
      /* Step 3 Define function drawChart where nearly all the work is done */ 
      function drawChart() {

				/* Step 4a Create the variable data: It's a DataTable */
				var data = new google.visualization.DataTable();
				
				/* Step 4b Define columns */       
				data.addColumn('string', 'Project');
				data.addColumn('number', 'Hours spent');
				data.addColumn('number', 'Customers');
				
				/* Step 4c Fill rows with data */
				data.addRows([['Pie charts', 621.05, 144], 
											['Bar charts', 741.48, 205], 
											['Tables', 281.47, 408], 
											['Gauges', 71.1, 109], 
											['Motions', 451.8, 849]
										]);

				/* Step 5a Set chart options for a pie chart */ 
				var options1 = {
					'title':'Time spent for projects', 
					'width':400, 
					'height':300, 
					'is3D':true
				};
				
				/* Step 5b Instantiate the chart, it will be placed in div_
				   chart1 in the body */
				var chart1 = new google.visualization.PieChart(
					document.getElementById('div_chart1'));
				
				/* Step 5c Draw the chart */
				chart1.draw(data, options1);

      	/* Step 6: bar chart, options passed directly */
				var chart2 = new google.visualization.BarChart(
					document.getElementById('div_chart2'));
				chart2.draw(data, {
					title:'Time spent and customers for projects', 
					width:400, 
					height:300
				});

				/* Step 7: show data as a table, with row numbers */
				var table = new google.visualization.Table(
					document.getElementById('div_table1'));
				table.draw(data, {showRowNumber: true, width:450});

      	/* Step 8: gauges, use view for the first two colums of data */
				var dataOnly2 = new google.visualization.DataView(data);
				dataOnly2.setColumns([0, 1]);
				var optionsGauge = {
					width:700, 
					height:200, 
					min:0, 
					max:1000, 
					yellowFrom:300, 
					yellowTo:500, 
					redFrom:500, 
					redTo:1000
				};     	
				new google.visualization.Gauge(
					document.getElementById('div_gauge')).draw(dataOnly2, optionsGauge);

				/* Step 9: motion chart: new data in motiondata; 
				           first column must be string, followed by a date */
				/* Data inserted by using variable m.placeholderForData */

				var motiondata = new google.visualization.DataTable();
				motiondata.addColumn('string', 'Project');
				motiondata.addColumn('date', 'date');
				motiondata.addColumn('number', 'Hours spent');
				motiondata.addColumn('number', 'Customers');

				<<m.placeholderForData>> ;

				var motionchart = new google.visualization.MotionChart(
					document.getElementById('div_motion'));
				var optionsMotion = {};		// it's easier to copy the initial state here
				optionsMotion['state'] = '{"colorOption":"_UNIQUE_COLOR"};';
				optionsMotion['width'] = 800;
				optionsMotion['height'] = 400;
				motionchart.draw(motiondata, optionsMotion);

      }
		</script>
	</head>
	
	<body>
    <h4>Two charts in a table with data source</h4>
		<table><tr>
			<td><div id="div_chart1"></div></td>
			<td><div id="div_chart2"></div></td>
    </tr></table>
    
    <h4>Table: click on the headers to sort</h4>
		<div id="div_table1"></div>

		<h4>Gauges: Hours spent</h3>
		<div id="div_gauge"></div>

		<h4>Motions only visible if Flash not blocked on local files; 
		    compare section "Overview" of "Motion Charts"
				at code.google.com/intl/de-DE/apis/chart/
				interactive/docs/gallery/motionchart.html</h4>
		<div id="div_motion"></div>
	</body>
</html>

ENDTEXT

	** show result
STRTOFILE(htmlResult, "chart.html")
DECLARE INTEGER ShellExecute IN SHELL32.DLL ;
	INTEGER nWinHandle, STRING cOperation, STRING cFileName, STRING cParameters, ;
	STRING cDirectory, INTEGER nShowWindow
ShellExecute(0, "open", "chart.html", "", NULL, 3)


**** loadDataFromVFP: only used for Motion Chart
FUNCTION loadDataFromVFP
	LOCAL i, randomNumber, laProjects, returnValue
	LOCAL laProjects[5]
	laProjects[1] = 'Pie Charts'
	laProjects[2] = 'Bar Charts'
	laProjects[3] = 'Gauges Charts'
	laProjects[4] = 'Tables'
	laProjects[5] = 'Motions'
	
		** create cursor and insert some data
	CREATE CURSOR project (name C(30), dayOfWork D, hours N(10,2), customers N(10))
	FOR i = 1 TO 100
		randomNumber = MIN (1 + RAND() * 5, 5)
		INSERT INTO project VALUES ( ;
			laProjects[m.randomNumber], ;
			DATE() + RAND() * 100, ;
			m.randomNumber * 200, ;
			RAND () * 50 ;
		)
	ENDFOR
	
		** Build string for step 9 (Motion Chart): DataTable called 'motiondata'
	returnValue = 'motiondata.addRows(['		&& we use a DataTable called motiondata 
	SELECT project
	SCAN
			* Note: JavaScript is case sensitive ('new Date')
		m.returnValue = m.returnValue + CHR(13) + "['" + ALLTRIM(name) + "'" ;
				+ ", new Date(" + TRANSFORM(YEAR (dayOfWork)) ;
				+ ", " + TRANSFORM(MONTH (dayOfWork)) + ", " ;
				+ TRANSFORM(DAY (dayOfWork)) + ")" ;
				+ ", " + LTRIM (STR(hours, 10, 2)) ;
				+ ", " + TRANSFORM(customers) ;
				+ "],"
	ENDSCAN
	m.returnValue = LEFT (m.returnValue, LEN (m.returnValue) - 1)	&& remove last comma
	m.returnValue = m.returnValue + "])"
RETURN m.returnValue
