*==================================================
* Add common files of a project to VSS without 
* forcing you to get the latest version.
*==================================================
LParameter tcProject, tcCommonDir

	*-----------------------------------------------
	* Check parameter. This is an interactive tool.
	* Therefore we inform the user if something 
	* went wrong.
	*-----------------------------------------------
	If Type("tcProject") # "C"
		Wait Window "Project name required!"
		Return
	Endif
	If Type("tcCommonDir") # "C"
		Wait Window "Common directory required!"
		Return
	Endif
	
	*-----------------------------------------------
	* Open the project file as a table.
	*-----------------------------------------------
	If not File(tcProject+".PJX")
		Wait Window "Project doesn't exist!"
		Return
	Endif
	Use (tcProject+".Pjx") Again ;
		Alias _PJX In 0 Shared
	Select _PJX
	
	*-----------------------------------------------
	* Add all files to SourceSafe. Skip the first
	* record that contains project specific
	* information.
	*-----------------------------------------------
	Local lcSCCData, lcDir
	lcSCCData = ;
		Replicate( Chr(0x00), 260 ) + ;
		Chr(0x01) + Chr(00) + ;
		Replicate( Chr(0x00), 6 )
	lcDir = Upper(Alltrim(tcCommonDir))
	Replace All ;
			Local with .F.,;
			SccData with lcSCCData ;
		For Left(Upper(Name),Len(lcDir)) == lcDir ;
		and RecNo() > 1
		
	*-----------------------------------------------
	* Close the project file.
	*-----------------------------------------------
	Use in _Pjx
	
Return
