*========================================================
*
* Let's you specify the login information that is used by
* VFP for all further projects you open which are placed 
* under version control.
*
*--------------------------------------------------------
* SYNTAX
*
* SetVSSDB( [tcDatabase], [tcUser], [tcPassword] )
*
* Pass the login information. If you want to clear the 
* settings and restore the defaults, you can omit a 
* parameter or pass NULL.
*
*========================================================
LParameter tcDatabase, tcUser, tcPassword

  *------------------------------------------------------
  * Get the login information. By using NULL, we remove 
  * the environment variables.
  *------------------------------------------------------
  Local lcUser, lcPassword
  If Type("m.tcUser")=="C" and Type("m.tcPassword")=="C"
    lcUser = m.tcUser
    lcPassword = m.tcPassword
  Else
    lcUser = Alltrim(NULL)
    lcPassword = Alltrim(NULL)
  Endif
  
  *------------------------------------------------------
  * Set the environment variables SSUSER and SSPWD
  *------------------------------------------------------
  Local llOK
  llOK = .T.
  Declare Long SetEnvironmentVariable in Win32API ;
    String, String
  If SetEnvironmentVariable( "SSUSER", m.lcUser ) == 0
    llOK = .F.
  Endif
  If SetEnvironmentVariable( "SSPWD", m.lcPassword ) == 0
    llOK = .F.
  Endif

  *------------------------------------------------------
  * Change the default database in the registry
  *------------------------------------------------------
  Local loRegistry
  If Vartype(m.tcDatabase) == "C"
    loRegistry =  NewObject( ;
      "Registry", Home()+"\FFC\Registry.vcx" )
    loRegistry.OpenKey( ;
      "Software\Microsoft\SourceSafe", 0x80000002, .F. )
    loRegistry.SetKeyValue( ;
      "Current Database", m.tcDatabase )
    loRegistry.CloseKey()
  Endif 

Return m.llOK

