*========================================================================================
* Generates the text files for all files in a project
*========================================================================================
Lparameters tcProject

	*--------------------------------------------------------------------------------------
	* A few settings
	*--------------------------------------------------------------------------------------
	Set Deleted on
	
	*--------------------------------------------------------------------------------------
	* Query the project file if none has been passed in
	*--------------------------------------------------------------------------------------
	Local lcProject
	If Vartype(m.tcProject) == "C" and File(m.tcProject)
		lcProject = m.tcProject
	Else
		lcProject = GetFile( "pjx", "Select a project file" )
		If not File(m.lcProject)
			Return
		EndIf 
	EndIf
	
	*--------------------------------------------------------------------------------------
	* Go through all files and convert them
	*--------------------------------------------------------------------------------------
	Local lcFile
	USE (m.lcProject) Again Shared Alias PJX
	Scan for Recno() >= 2
		lcFile = Addbs(JustPath(m.lcProject)) + Chrtran(PJX.Name,Chr(0),"")
		DO MakeTextFile in FoxDiff with m.lcFile, m.lcFile, "NOTHING"
	EndScan
