*========================================================================================
* FoxDiff.Prg    1.0.2
*
* (w) 2003-2004 Christof Wollenhaupt, Foxpert, Hamburg, Germany
*
* Placed into the Public Domain. You may use this program in its entirety or just parts
* from it in any legal way. There's no warranty. You use this program at your own risk.
*
*========================================================================================
LParameter tcLeft, tcRight, tcOption

	*--------------------------------------------------------------------------------------
	* Thanks to Ken Green for adding the following code:
	* Help out our poor user - (s)he's too tired to enter variables
	*--------------------------------------------------------------------------------------
	LOCAL lcExt
	IF EMPTY(tcLeft)
		 tcLeft = GETFILE('VFP Files:SCX,LBX,MNX,FRX,VCX,DBF,DOC,PRG', ;
		   'Select 1st File', 'Select', 0, 'Compare Files')
		IF EMPTY(tcLeft)
			WAIT WINDOW NOWAIT 'FoxDiff Aborted - no 1st file name' TIMEOUT 15
			RETURN
		ENDIF
	ENDIF
	IF EMPTY(tcRight)
		lcExt = UPPER(JUSTEXT(m.tcLeft))
		tcRight = GETFILE('Match File:' + lcExt, ;
			'Select 2nd File', 'Select', 0, 'Compare Files')
		IF EMPTY(tcRight)
			WAIT WINDOW NOWAIT 'FoxDiff Aborted - no 2nd file name' TIMEOUT 15
			RETURN
		ENDIF
	ENDIF
	IF VARTYPE(tcOption) <> 'C'
		tcOption = ''
	ENDIF

	*--------------------------------------------------------------------------------------
	* Specify here the tool called to perform the actual file comparision. Use lcLeft and
	* lcRight to specify the files.
	*--------------------------------------------------------------------------------------
	#DEFINE DIFFTOOL ["]+Addbs(GetEnv("ProgramFiles"))+[Beyond Compare 2\BC2.exe"]
	#DEFINE DIFFPARM ["]+m.lcLeft+[" "]+m.lcRight+["]

	Set Safety off
	DO case
	
	*--------------------------------------------------------------------------------------
	* CVS: We convert both files to text and display that in the diff tool. WinCVS stores
	*      older versions in the temporary directory using name.x.x.x.x_n.vcx as the name,
	*      where x is a version and n is incremented for each file. As a result, the vcx 
	*      and vct have different names. We copy the file to a plain named one.
	*--------------------------------------------------------------------------------------
	Case Upper(m.tcOption) == "CVS"
		DiffFiles( GetCVSFile(m.tcLeft), GetCVSFile(m.tcRight), "NOTHING" )
	
	*--------------------------------------------------------------------------------------
	* SOS: We convert both files to text and display that in the diff tool. SourceOffSite
	*      stores older versions in the temporary directory using xxxx\name.vcx_version_n 
	*      as the name where n is the version of the file and xxxx is a random sub 
	*      directory.
	*--------------------------------------------------------------------------------------
	Case Upper(m.tcOption) == "SOS"
		DiffFiles( GetSOSFile(m.tcLeft), GetSOSFile(m.tcRight), "NOTHING" )
	
	*--------------------------------------------------------------------------------------
	* UConv: The Beyond Compare UConvert PlugIn passes the name of the source and a target
	*        name. We convert 
	*--------------------------------------------------------------------------------------
	Case Upper(m.tcOption) == "UCONV"
		MakeTextFile( m.tcLeft, m.tcRight, "COPY" )
	
	*--------------------------------------------------------------------------------------
	* BC2: Convert files for Beyond Compare 2.x.
	*--------------------------------------------------------------------------------------
	Case Upper(m.tcOption) == "BC2"
		MakeTextFile( m.tcLeft, m.tcRight, "COPY", .T. )
	
	*--------------------------------------------------------------------------------------
	* Otherwise we simple compare the two files after converting them to text.
	*--------------------------------------------------------------------------------------
	Otherwise 
		DiffFiles( m.tcLeft, m.tcRight )
	
	EndCase 

EndProc 


*========================================================================================
* Copies a file version generated by WinCVS
*========================================================================================
Procedure GetCVSFile
LParameter tcFile

	Local lcFile
	
	If "_" $ m.tcFile and Empty(Chrtran(JustStem(SubStr(m.tcFile,Rat("_",m.tcFile)+1)),"1234567890_.",""))
		lcFile = Left(m.tcFile,Rat("_",m.tcFile)-1)+"."+JustExt(m.tcFile)
		Copy File(m.tcFile) to (m.lcFile)
	Else
		lcFile = m.tcFile
	EndIf 

Return m.lcFile


*========================================================================================
* Copies a file version generated by SourceOffSize
*========================================================================================
Procedure GetSOSFile
LParameter tcFile

	Local lcFile
	
	Do case
	
	*--------------------------------------------------------------------------------------
	* older versions of SourceOffSite inserted the String "_VERSION_" right 
	*--------------------------------------------------------------------------------------
	Case "_VERSION_" $ Upper(m.tcFile)
		lcFile = Addbs(GetEnv("TEMP")) + ;
			JustFname(Left(m.tcFile,Rat("_VERSION_",Upper(m.tcFile))-1))
		Copy File(m.tcFile) to (m.lcFile)
	
	*--------------------------------------------------------------------------------------
	* More recent versions use _Version_xxx_file as the name
	*--------------------------------------------------------------------------------------
	Case Left(Upper(JustFname(m.tcFile)),8) == "VERSION_"
		lcFile = Substr(JustFname(m.tcFile),9)
		lcFile = Addbs(GetEnv("TEMP")) + Substr( m.lcFile, At("_",m.lcFile)+1 )
		If File(m.lcFile)
			Erase (m.lcFile)
		EndIf
		Copy File(m.tcFile) to (m.lcFile)

	*--------------------------------------------------------------------------------------
	* Other files
	*--------------------------------------------------------------------------------------
	Otherwise 
		lcFile = m.tcFile
	EndCase 

Return m.lcFile


*========================================================================================
* Generates a text file using either the specified target name or a random name.
*========================================================================================
Procedure MakeTextFile
LParameter tcSource, tcTarget, tcDefaultAction, tlKeepTargetExtension

	*--------------------------------------------------------------------------------------
	* Determine the target file
	*--------------------------------------------------------------------------------------
	Local lcTarget, lcExtension
	If Vartype(m.tcTarget) == "C" and not Empty(m.tcTarget)
		lcTarget = m.tcTarget
		lcExtension = JustExt(m.tcTarget)
	else
		lcTarget = Addbs(GetEnv("Temp"))+Sys(3)
		lcExtension = "txt"
	EndIf 
	
	*--------------------------------------------------------------------------------------
	* Determine action for this type of source file
	*--------------------------------------------------------------------------------------
	Local lcType, lcAction
	DO Case
	Case Upper(JustExt(m.tcSource)) == "SCX" 
		lcType = "K"
		lcAction = "SCCTEXT"
		lcExtension = "SCA"
	Case Upper(JustExt(m.tcSource)) == "LBX"
		lcType = "B"
		lcAction = "SCCTEXT"
		lcExtension = "LBA"
	Case Upper(JustExt(m.tcSource)) == "MNX"
		lcType = "M"
		lcAction = "SCCTEXT"
		lcExtension = "MNA"
	Case Upper(JustExt(m.tcSource)) == "FRX" 
		lcType = "R"
		lcAction = "SCCTEXT"
		lcExtension = "FRA"
	Case Upper(JustExt(m.tcSource)) == "VCX"
		lcType = "V"
		lcAction = "SCCTEXT"
		lcExtension = "VCA"
	Case Upper(JustExt(m.tcSource)) == "DBF" 
		lcAction = "XML"
		lcExtension = "XML"
	Case Upper(JustExt(m.tcSource)) == "PJX" 
		lcAction = "XML"
		lcExtension = "XML"
	Case Upper(JustExt(m.tcSource)) == "DOC"
		lcAction = "WORD"
		lcExtension = "HTML"
	Case Upper(JustExt(m.tcSource)) == "RDF"
		lcAction = "RDFREX"
		lcExtension = "REX"
	Otherwise 
		If Vartype(m.tcDefaultAction) == "C"
			lcAction = m.tcDefaultAction
		else
			lcAction = "COPY"
		EndIf 
	EndCase
	
	*--------------------------------------------------------------------------------------
	* Assemble the complete name of the target file
	*--------------------------------------------------------------------------------------
	If not m.tlKeepTargetExtension
		lcTarget = ForceExt( m.lcTarget, m.lcExtension )
	EndIf
	
	*--------------------------------------------------------------------------------------
	* copy file, convert to XML, HTML or produce a text file using SCCTEXT
	*--------------------------------------------------------------------------------------
	DO Case
	Case m.lcAction = "COPY"
		Copy File (m.tcSource) to (m.lcTarget)
	Case m.lcAction = "XML"
		USE (m.tcSource) Shared
		CursorToXML(Alias(),m.lcTarget,1,2+8+512+4096,0,"1")
	Case m.lcAction == "WORD"
		Local loWord, loDocument
		loWord = CreateObject("Word.Application")
		loDocument = loWord.Documents.Open(m.tcSource)
		loDocument.SaveAs(m.lcTarget,8)
		loDocument.Close(.F.)
		loWord.Quit(.F.)
	Case m.lcAction == "RDFREX"
		Local lcCommand, lcBuffer, lnLen
		Declare Long GetShortPathName in win32api string, string@, long
		lcBuffer = Space(260)
		lnLen = GetShortPathName(m.tcSource,@lcBuffer,Len(m.lcBuffer))
		If m.lnLen > 0
			lcCommand = [RWCON60 source="]+Left(m.lcBuffer,m.lnLen)+[" dest="]+m.lcTarget+;
				[" dtype=rexfile stype=rdffile batch=yes]
			Run &lcCommand
		EndIf 
	Case m.lcAction == "SCCTEXT"
		DO SccText with m.tcSource, m.lcType, m.lcTarget, .T.
	Case m.lcAction == "NOTHING"
		lcTarget = m.tcSource
	Endcase

Return m.lcTarget


*========================================================================================
* Creates a text version of the two files and compares them
*========================================================================================
Procedure DiffFiles
LParameter tcLeft, tcRight, tcAction

	*--------------------------------------------------------------------------------------
	* We assume that both sides have the same file type. If the left is not a leading file,
	* but a VCT, SCT, etc. file, we return immeadiately.
	*--------------------------------------------------------------------------------------
	If InList( Upper(JustExt(m.tcLeft)), "FRT", "SCT", "MNT", "VCT", "LBT", "PJT" )
		Return
	EndIf 

	*--------------------------------------------------------------------------------------
	* Convert the files to text
	*--------------------------------------------------------------------------------------
	Local lcLeft, lcRight
	lcLeft = MakeTextFile( m.tcLeft, "", m.tcAction )
	lcRight = MakeTextFile( m.tcRight, "", m.tcAction )
	
	*--------------------------------------------------------------------------------------
	* Call the Diff tool
	*--------------------------------------------------------------------------------------
	DECLARE INTEGER ShellExecute IN SHELL32.DLL ;
		INTEGER nWinHandle,;
		STRING cOperation,;   
		STRING cFileName,;
		STRING cParameters,;
		STRING cDirectory,;
		INTEGER nShowWindow
	ShellExecute( 0, "open", DIFFTOOL, DIFFPARM, NULL, 1 )
	
EndProc 