*====================================================================
* Determines some information about the available printer page area
* of a printer
*====================================================================
LParameter tcPrinter

	*-----------------------------------------------------------------
	* Load API declarations
	*-----------------------------------------------------------------
	#Include Header\ApiDef.H
	Do Program\ApiDef

	*-----------------------------------------------------------------
	* Determine printer information
	*-----------------------------------------------------------------
	Local HDC, lnHorzSize, lnVertSize, lnPhysicalWidth, ;
		lnPhysicalHeight, lnPhysicalOffsetX, lnPhysicalOffsetY, ;
		lnLogPixelsX, lnLogPixelsY
	HDC = CreateDC( "WINSPOOL", m.tcPrinter, NULL, NULL )
	lnHorzSize = GetDeviceCaps( m.HDC, HORZSIZE )
	lnVertSize = GetDeviceCaps( m.HDC, VERTSIZE )
	lnPhysicalWidth = GetDeviceCaps( m.HDC, PHYSICALWIDTH )
	lnPhysicalHeight = GetDeviceCaps( m.HDC, PHYSICALHEIGHT )
	lnPhysicalOffsetX = GetDeviceCaps( m.HDC, PHYSICALOFFSETX )
	lnPhysicalOffsetY = GetDeviceCaps( m.HDC, PHYSICALOFFSETY )
	lnLogPixelsY = GetDeviceCaps( m.HDC, LOGPIXELSY )
	lnLogPixelsX = GetDeviceCaps( m.HDC, LOGPIXELSX )
	DeleteDC(m.HDC)
	
	*-----------------------------------------------------------------
	* And display them on the form.
	*-----------------------------------------------------------------
	? "printable width  :", m.lnHorzSize/25.4
	? "printable height :", m.lnVertSize/25.4
	? "physical width   :", m.lnPhysicalWidth / m.lnLogPixelsX
	? "physical height  :", m.lnPhysicalHeight / m.lnLogPixelsY
	? "left margin      :", m.lnPhysicalOffsetX / m.lnLogPixelsX
	? "top margin       :", m.lnPhysicalOffsetY / m.lnLogPixelsY
