*====================================================================
* This program displays information about all your installed 
* printers. It uses the PRINTER_INFO_1 structure and the 
* WS_GetPrinter() API function to retrieve all this details. 
*====================================================================

	*-----------------------------------------------------------------
	* Declare API function and load libraries
	*-----------------------------------------------------------------
	Set ClassLib to ClassLib\Struct, ClassLib\WinStruct Additive
	Do Program\ApiDef
	
	*-----------------------------------------------------------------
	* Create structure
	*-----------------------------------------------------------------
	Local loPrtInfo
	loPrtInfo = CreateObject( "PRINTER_INFO_1" )
	
	*-----------------------------------------------------------------
	* Fills an array with all printers and creates a cursor for the
	* results.
	*-----------------------------------------------------------------
	Local laPrinters[1,2], lnPrinters
	lnPrinters = APrinters( laPrinters )
	Create Cursor curInfo( ;
		Flags I, ;
		pDescription C(128), ;
		pName C(128), ;
		pComment C(128) ;
	)
	
	*-----------------------------------------------------------------
	* Determine printer information for all defined printers. 
	* WS_GetPrinter() fills a PRINTER_INFO_1 structure. Since it
	* gets a pointer to a buffer that contains a PRINTER_INFO_1
	* structure, we have to use GetPointer() here instead of 
	* GetString().
	*-----------------------------------------------------------------
	Local lnCurrent, lnHandle, lnOK, lnBuffer, lnNeeded, lnSize
	For lnCurrent = 1 to m.lnPrinters
		lnHandle = 0
		lnOK = WS_OpenPrinter( ;
			laPrinters[m.lnCurrent,1], ;
			@lnHandle, ;
			NULL ;
		)
		If m.lnOK == 0
			Loop
		Endif
		lnNeeded = 0
		lnSize = 1000
		lnBuffer = loPrtInfo.GetPointer( m.lnSize )
		lnOK = WS_GetPrinter( ;
			m.lnHandle, ;
			1, ;
			m.lnBuffer, ;
			m.lnSize, ;
			@lnNeeded ;
		)
		loPrtInfo.SetPointer( m.lnBuffer )
		loPrtInfo.FreePointer( m.lnBuffer )
		If not m.lnOK == 0
			Insert into curInfo Values ( ;
				m.loPrtInfo.Flags, ;
				m.loPrtInfo.pDescription, ;
				m.loPrtInfo.pName, ;
				m.loPrtInfo.pComment ;
			)
		Endif
		WS_ClosePrinter( m.lnHandle )
	Endfor
	
	*-----------------------------------------------------------------
	* Finally, display the list
	*-----------------------------------------------------------------
	Select curInfo
	Browse Normal
	Use in curInfo
	