*====================================================================
* This demo program retrieves the version info of the current 
* Windows system using the GetVersionEx() API function.
*====================================================================
	
	*-----------------------------------------------------------------
	* Declare API function and load libraries
	*-----------------------------------------------------------------
	Set ClassLib to ClassLib\Struct, ClassLib\WinStruct Additive
	Do Program\ApiDef
	
	*-----------------------------------------------------------------
	* Create Structure. OSVERSIONINFO requires that you initialize it 
	* with the size of the structure. The SizeOf() returns this size.
	*-----------------------------------------------------------------
	Local loOSVersionInfo
	loOSVersionInfo = CreateObject( "OSVERSIONINFO" )
	loOSVersionInfo.dwOSVersionInfoSize = loOSVersionInfo.SizeOf()
	
	*-----------------------------------------------------------------
	* Get the version info and display them on the screen
	*-----------------------------------------------------------------
	Local lcVersion
	With loOSVersionInfo	
		lcVersion = .GetString()
		GetVersionEx( @lcVersion )
		.SetString( m.lcVersion )
		? "SizeOf       :", .dwOSVersionInfoSize
		? "Major version:", .dwMajorVersion
		? "Minor version:", .dwMinorVersion
		? "Build number :", Transform(.dwBuildNumber,"@0")
		? "Platform ID  :", .dwPlatformID
		? "Version      :", '"'+.szCSDVersion+'"'
	Endwith
