*====================================================================
* This sample uses the Microsoft Windows Networking functions to
* determine the UNC (Universal Name Convention) name for every mapped
* drive. Such a name would look like \\Server\Volume\Directory. The
* result is displayed in a BROWSE window.
*====================================================================
	
	#INCLUDE Header\ApiDef.H
	
	*-----------------------------------------------------------------
	* Declare API function and load libraries
	*-----------------------------------------------------------------
	Set ClassLib to ClassLib\Struct, ClassLib\WinStruct Additive
	Do Program\ApiDef
	
	*-----------------------------------------------------------------
	* Create a REMOTE_NAME_INFO structure and get a pointer to this
	* structure. Since Windows stores the return strings inside the
	* buffer beyond the structure, we have to get a pointer here that
	* points to a memory block large enough to hold the structure
	* as well as the result.
	*-----------------------------------------------------------------
	Local loRemoteNameInfo, lnBuffer, lnRemoteNameInfo
	loRemoteNameInfo = CreateObject("REMOTE_NAME_INFO")
	lnBuffer = 1000
	lnRemoteNameInfo = loRemoteNameInfo.GetPointer( m.lnBuffer )
	
	*-----------------------------------------------------------------
	* Create the cursor that holds the result for all network drives.
	*-----------------------------------------------------------------
	Create Cursor curDrives ( ;
		cDrive C(2), ;
		lpUniversalName C(160), ;
		lpConnectionName C(160), ;
		lpRemainingPath C(160) ;
	)

	*-----------------------------------------------------------------
	* We loop through the drives from C: to Z: and find out what the
	* universal name actually is. If a drive doesn't exist, is not
	* connected or is a local device, lnError would be a non-zero
	* value. If the return value is 0, we update the structure and
	* insert the return values into the cursor.
	*-----------------------------------------------------------------
	Local lnDrive, lnError
	For lnDrive = Asc("C") to Asc("Z")
		lnBuffer = 1000
		lnError = WNetGetUniversalName(;
			Chr(m.lnDrive)+":", ;
			REMOTE_NAME_INFO_LEVEL, ;
			m.lnRemoteNameInfo, ;
			@lnBuffer ;
		)
		If m.lnError == 0
			loRemoteNameInfo.SetPointer( m.lnRemoteNameInfo )	
			Insert into curDrives Value ( ;
				Chr(m.lnDrive)+":", ;
				loRemoteNameInfo.lpUniversalName, ;
				loRemoteNameInfo.lpConnectionName, ;
				loRemoteNameInfo.lpRemainingPath ;
			)
		Endif
	Endfor
	
	*-----------------------------------------------------------------
	* Whenever we allocate memory for a buffer, we have to release 
	* that portion of memory in order to avoid memory leaks. 
	* FreePointer() is the method that does the job for us.
	*-----------------------------------------------------------------
	loRemoteNameInfo.FreePointer( m.lnRemoteNameInfo )
	
	*-----------------------------------------------------------------
	* Now we can display the resulting cursor that holds detailed 
	* information about all network drives.
	*-----------------------------------------------------------------
	Browse Normal
	Use in curDrives
