*====================================================================
* This program uses FindFirstFile() and FindNextFile() to get a list
* of all files in the current directory.
*
* This sample program requires VFP 6.0!
*
*====================================================================
	
	#INCLUDE Header\FoxPro.H
	
	*-----------------------------------------------------------------
	* Declare API function and load libraries
	*-----------------------------------------------------------------
	Set ClassLib to ClassLib\Struct, ClassLib\WinStruct Additive
	Do Program\ApiDef
	
	*-----------------------------------------------------------------
	* Create the structure. The file times are stored in substructures
	* that are based on FILETIME.
	*-----------------------------------------------------------------
	Local loFindFile
	loFindFile = CreateObject( "WIN32_FIND_DATA" )
	loFindFile.ftCreationTime = CreateObject( "FILETIME" )
	loFindFile.ftLastAccessTime = CreateObject( "FILETIME" )
	loFindFile.ftLastWriteTime = CreateObject( "FILETIME" )
	
	*-----------------------------------------------------------------
	* Start the search be finding the first file
	*-----------------------------------------------------------------
	Local lnHandle, lcFindFile, lcFile
	lcFindFile = loFindFile.GetString()
	lcFile = Sys(5)+Sys(2003)+"\*.*"
	lnHandle = FindFirstFile( m.lcFile, @lcFindFile )
	If m.lnHandle == -1
		Return
	Endif

	*-----------------------------------------------------------------
	* Create a Cursor for the result.
	*-----------------------------------------------------------------
	Create Cursor curFiles ( ;
		cFileName C(128), ;
		cShortName C(14), ;
		nSize N(10), ;
		tCreated T, ;
		tAccess T, ;
		tWrite T ;
	)
	
	*-----------------------------------------------------------------
	* Now find all files in a loop and add the files to the cursor.
	* At the end of the loop we call FindNextFile to get the next 
	* file. If there's no more file, this function returns 0.
	*-----------------------------------------------------------------
	Local llOK
	With loFindFile
		llOK = .T.
		Do While	m.llOK
			.SetString( m.lcFindFile )
			Insert into curFiles Values ( ;
				.cFileName, ;
				.cAlternateFileName, ;
				(.nFileSizeHigh * 2^32) + .nFileSizeLow, ;
				FileTimeToDateTime( .ftCreationTime ), ;
				FileTimeToDateTime( .ftLastAccessTime ), ;
				FileTimeToDateTime( .ftLastWriteTime ) ;
			)
			.cFileName = ""
			.cAlternateFileName = ""
			lcFindFile = .GetString()
			If FindNextFile( m.lnHandle, @lcFindFile ) == 0
				llOK = .F.
			Endif
		Enddo
	Endwith
	
	*-----------------------------------------------------------------
	* After we finished the search, we have to tell WIndows that we
	* don't need the handle anymore.
	*-----------------------------------------------------------------
	FindClose( m.lnHandle )
	
	*-----------------------------------------------------------------
	* After that we can display the result
	*-----------------------------------------------------------------
	Select curFiles
	Browse Normal
	
Return


*====================================================================
* The time in a FILETIME structure is stored in 100st nano seconds 
* since January 1, 1601 in Coordinated Universal Time (UTC) format.
* To convert it into a datetime, we have to perform 3 steps. First,
* we calculate the file time based on local time, than we convert it
* into a SYSTEMTIME structure and finally we make a datetime value
* out of it.
*====================================================================
Procedure FileTimeToDateTime
LParameter toFileTime
	
	*-----------------------------------------------------------------
	* Convert the FileTime structure into local time.
	*-----------------------------------------------------------------
	Local loLocalFileTime, lcLocalTime
	loLocalFileTime = CreateObject( "FILETIME" )
	lcLocalTime = loLocalFileTime.GetString()
	FileTimeToLocalFileTime( toFileTime.GetString(), @lcLocalTime )
	
	*-----------------------------------------------------------------
	* Convert the local file time into a SYSTEMTIME structure
	*-----------------------------------------------------------------
	Local loSystemTime, lcSystemTime
	loSystemTime = CreateObject( "SYSTEMTIME" )
	lcSystemTime = loSystemTime.GetString()
	FileTimeToSystemTime( lcLocalTime, @lcSystemTime )
	loSystemTime.SetString( m.lcSystemTime )
	
	*-----------------------------------------------------------------
	* Now we can use VFP's DateTime function to conver the SYSTEMTIME
	* structure into a datetime variable
	*-----------------------------------------------------------------
	Local ltFileTime
	With loSystemTime
		ltFileTime = DateTime( ;
			.wYear, ;
			.wMonth, ;
			.wDay, ;
			.wHour, ;
			.wMinute, ;
			.wSecond ;
		)
	Endwith
	
Return m.ltFileTime