*====================================================================
* This file contains API functions that can't be declard directly.
* Usually the reason is that there are several possible declaration
* that depend on the situation in which you want to use the API 
* function. 
* Instead, call the function in this procedure file. They automati-
* cally choose the right conversion function depending on the para-
* meters you pass.
*
* Written by Christof Lange, 1999
* Placed into Public Domain by The Foxpert!
*
*====================================================================


*====================================================================
* Basic memory operations
*
* Especially these functions are difficult to declare. In some
* cases you have the address as a numeric value, for example, if
* you allocated memory before. In other cases you have got a 
* string, mainly if you want to copy memory from a VFP string.
*
* For this reason, all basic memory operations are wrapped by VFP
* functions that issue the proper delcaration based on the type of
* parameter you pass them.
* 
* NOTE: The API functions you find in the platform SDK are in fact
*       C macros that are redirected to several other functions.
*       The CopyMemory() function actually refers to memcpy() in 
*       the Visual C runtime library.
*       (See: "Hardcore Visual Basic" by Bruce McKinney)
*====================================================================


*====================================================================
* This function copies memory from the Source address to the 
* destination address. Both pointers can either be represented by 
* VFP strings, or by numeric addresses. The destination must be
* passed by reference, if it's a string.
*====================================================================
Procedure CopyMemory
LParameter tuDestination, tuSource, tnLength

	*-----------------------------------------------------------------
	* Determine the type of the destination buffer.
	*-----------------------------------------------------------------
	Local lcDestType
	If Type("m.tuDestination") == "C"
		lcDestType = "String@"
	Else
		lcDestType = "Integer"
	Endif
	
	*-----------------------------------------------------------------
	* Determine the type of the source buffer.
	*-----------------------------------------------------------------
	Local lcSourceType
	If Type("m.tuSource") == "C"
		lcSourceType = "String"
	Else
		lcSourceType = "Integer"
	Endif
	
	*-----------------------------------------------------------------
	* Declare the API function. Since CopyMemory is actually a macro
	* for RtlCopyMemory and RtlCopyMemory is a macro for a C runtime
	* library function memcpy, we use RtlMoveMemory here.
	*-----------------------------------------------------------------
	Declare RtlMoveMemory in Win32API as __CopyMemory ;
		&lcDestType, &lcSourceType, Integer
	
	*-----------------------------------------------------------------
	* Copy the block of memory.
	*-----------------------------------------------------------------
	External Array __CopyMemory
	If Type("m.tuDestination") == "C"
		__CopyMemory( @tuDestination, m.tuSource, m.tnLength )
	Else
		__CopyMemory( m.tuDestination, m.tuSource, m.tnLength )
	Endif
	
EndProc


*====================================================================
* This function moves memory from the Source address to the 
* destination address. Both pointers can either be represented by 
* VFP strings, or by numeric addresses. The destination must be
* passed by reference, if it's a string. The difference between
* CopyMemory and MoveMemory is that MoveMemory can deal with over-
* lapping blocks of memory.
* This function is similar to VFP's string assignment functions and
* the STUFF() function.
*====================================================================
Procedure MoveMemory
LParameter tuDestination, tuSource, tnLength

	*-----------------------------------------------------------------
	* Determine the type of the destination buffer.
	*-----------------------------------------------------------------
	Local lcDestType
	If Type("m.tuDestination") == "C"
		lcDestType = "String@"
	Else
		lcDestType = "Integer"
	Endif
	
	*-----------------------------------------------------------------
	* Determine the type of the source buffer.
	*-----------------------------------------------------------------
	Local lcSourceType
	If Type("m.tuSource") == "C"
		lcSourceType = "String"
	Else
		lcSourceType = "Integer"
	Endif
	
	*-----------------------------------------------------------------
	* Declare the API function. MoveMemory() is actually a macro for
	* RtlMoveMemory() which is the function we use here.
	*-----------------------------------------------------------------
	Declare RtlMoveMemory in Win32API as __MoveMemory ;
		&lcDestType, &lcSourceType, Integer
	
	*-----------------------------------------------------------------
	* Move the block of memory.
	*-----------------------------------------------------------------
	External Array __MoveMemory
	If Type("m.tuDestination") == "C"
		__MoveMemory( @tuDestination, m.tuSource, m.tnLength )
	Else
		__MoveMemory( m.tuDestination, m.tuSource, m.tnLength )
	Endif
	
EndProc


*====================================================================
* Fills a memory block with a certain byte. This function is similar
* to VFP's STUFF() and REPLICATE() functions. The destination 
* address can either be a string or a numeric memory address. If it's
* a string, you have to pass it by reference.
* Since the FillMemory() API function you can find in MSDN is 
* actually a macro to RtlFillMemory(), we use that function here.
*====================================================================
Procedure FillMemory
LParameter tuDestination, tnLength, tnFill

	*-----------------------------------------------------------------
	* The destination is a string.
	*-----------------------------------------------------------------
	If Type("m.tuDestination") == "C"
		Declare RtlFillMemory in Win32API as __FillMemory ;
			String @Destination, ;
			Integer Length, ;
			Short Fill
		__FillMemory( @tuDestination, m.tnLength, m.tnFill )
	
	*-----------------------------------------------------------------
	* The destination is an address
	*-----------------------------------------------------------------
	Else
		Declare RtlFillMemory in Win32API as __FillMemory ;
			Integer Destination, ;
			Integer Length, ;
			Short Fill
		__FillMemory( m.tuDestination, m.tnLength, m.tnFill )
	Endif
	
EndProc


*====================================================================
* This function is similar to FillMemory, but is used a CHR(0) value
* to fill the block of memory. The destination address can be either
* a string or a memory address. If it's a string, you have to pass
* it by reference.
*====================================================================
Procedure ZeroMemory
LParameter tuDestination, tnLength

	*-----------------------------------------------------------------
	* The destination is a string.
	*-----------------------------------------------------------------
	If Type("m.tuDestination") == "C"
		Declare RtlZeroMemory in Win32API as __ZeroMemory ;
			String @Destination, ;
			Integer Length
		__ZeroMemory( @tuDestination, m.tnLength )
	
	*-----------------------------------------------------------------
	* The destination is an address
	*-----------------------------------------------------------------
	Else
		Declare RtlZeroMemory in Win32API as __ZeroMemory ;
			Integer Destination, ;
			Integer Length
		__ZeroMemory( m.tuDestination, m.tnLength )
	Endif
	
EndProc

