*====================================================================
* This program declares resource related API functions.
*
* Docs: Platform SDK > User Interface Services > Windows User
*       Interface > Resources
*
*====================================================================

	#INCLUDE Header\Declare.H
	
	*-----------------------------------------------------------------
	* String functions: string conversion. 
	* NOTE: Because these functions are handled pretty fine by VFP for
	*       VFP strings, the following declarations are all meant for
	*       memory strings. That means, the parameter is an address
	*       to a string.
	*-----------------------------------------------------------------
	Declare INT_LPTSTR CharLower in Win32API ;
		INT_LPTSTR lpsz
	
	Declare DWORD CharLowerBuff in Win32API ;
		INT_LPTSTR lpsz, ;
		DWORD cchLength
	
	Declare INT_LPTSTR CharUpper in Win32API ;
		INT_LPTSTR lpsz
	
	Declare DWORD CharUpperBuff in Win32API ;
		INT_LPTSTR lpsz, ;
		DWORD cchLength
	
	*-----------------------------------------------------------------
	* String functions: string navigation.
	* NOTE: Because these functions are handled pretty fine by VFP for
	*       VFP strings, the following declarations are all meant for
	*       memory strings. That means, the parameter is an address
	*       to a string.
	*-----------------------------------------------------------------
	Declare INT_LPTSTR CharNext in Win32API ;
		INT_LPCSTR lpsz
		
	Declare INT_LPSTR CharNextExA in Win32API ;
		WORD CodePage, ;
		INT_LPCSTR lpCurrentChar, ;
		DWORD dwFlags

	Declare INT_LPTSTR CharPrev in Win32API ;
		INT_LPCTSTR lpszStart, ;
		INT_LPCTSTR lpszCurrent

	Declare INT_LPSTR CharPrevExA in Win32API ;
		WORD CodePage, ;
		INT_LPCSTR lpStart, ;
		INT_LPCSTR lpCurrentChar, ;
		DWORD dwFlags

	*-----------------------------------------------------------------
	* String functions: OEM conversion
	*-----------------------------------------------------------------
	Declare BOOL CharToOem in Win32API ;
		LPCTSTR lpszSrc, ;
		LPSTR lpszDst
	
	Declare BOOL CharToOemBuff in Win32API ;
		LPCTSTR lpszSrc, ;
		LPSTR lpszDst, ;
		DWORD cchDstLength

	Declare BOOL OemToChar IN Win32API ;
		LPCSTR lpszSrc, ;
		LPTSTR lpszDst

	Declare BOOL OemToCharBuff in Win32API ;
		LPCSTR lpszSrc, ;
		LPTSTR lpszDst, ;
		DWORD cchDstLength
	
	*-----------------------------------------------------------------
	* String functions: working with collate seqeunces
	*-----------------------------------------------------------------
	Declare int CompareString in Win32API ;
		LCID Locale, ;
		DWORD dwCmpFlags, ;
		LPCTSTR lpString1, ;
		int cchCount1, ;
		LPCTSTR lpString2, ;
		int cchCount2

	Declare int FoldString in Win32API ;
		DWORD dwMapFlags, ;
		LPCTSTR lpSrcStr, ;
		int cchSrc, ;
		LPTSTR lpDestStr, ;
		int cchDest
		
	Declare BOOL GetStringTypeA in Win32API ;
		LCID Locale, ;
		DWORD dwInfoType, ;
		LPCSTR lpSrcStr, ;
		int cchSrc, ;
		LPWORD lpCharType
	
	Declare BOOL GetStringTypeEx in Win32API ;
		LCID Locale, ;
		DWORD dwInfoType, ;
		LPCTSTR lpSrcStr, ;
		int cchSrc, ;
		LPWORD lpCharType
	
	Declare BOOL GetStringTypeW in Win32API ;
		DWORD dwInfoType, ;
		LPCWSTR lpSrcStr, ;
		int cchSrc, ;
		LPWORD lpCharType

	*-----------------------------------------------------------------
	* String functions: string information
	* NOTE: TCHAR is a numeric parameter, you have to ASC() to convert
	*       a string into a TCHAR type.
	*-----------------------------------------------------------------
	Declare BOOL IsCharAlpha in Win32API ;
		TCHAR ch
	
	Declare BOOL IsCharAlphaNumeric in Win32API ;
		TCHAR ch
	
	Declare BOOL IsCharLower in Win32API ;
		TCHAR ch
	
	Declare BOOL IsCharUpper in Win32API ;
		TCHAR ch
	
	*-----------------------------------------------------------------
	* String functions: resource file handling
	*-----------------------------------------------------------------
	Declare int LoadString in Win32API ;
		HINSTANCE hInstance, ;
		UINT uID, ;
		LPTSTR lpBuffer, ;
		int nBufferMax
	
	*-----------------------------------------------------------------
	* String functions: basic string manipulation
	* NOTE: Because these functions are handled pretty fine by VFP for
	*       VFP strings, the following declarations are all meant for
	*       memory strings. That means, the parameter is an address
	*       to a string.
	* NOTE: For these functions we define the ANSI version and the 
	*       Unicode version if available. The Unicode version has "W"
	*       appended to the name.
	*-----------------------------------------------------------------
	Declare INT_LPTSTR lstrcat in Win32API ;
		INT_LPTSTR lpString1, ;
		INT_LPCTSTR lpString2

	Declare INT_LPTSTR lstrcatW in Win32API ;
		INT_LPTSTR lpString1, ;
		INT_LPCTSTR lpString2
	
	Declare int lstrcmp in Win32API ;
		INT_LPCTSTR lpString1, ;
		INT_LPCTSTR lpString2

	Declare int lstrcmpW in Win32API ;
		INT_LPCTSTR lpString1, ;
		INT_LPCTSTR lpString2

	Declare int lstrcmpi in Win32API ;
		INT_LPCTSTR lpString1, ;
		INT_LPCTSTR lpString2
	
	Declare int lstrcmpiW in Win32API ;
		INT_LPCTSTR lpString1, ;
		INT_LPCTSTR lpString2
	
	Declare INT_LPTSTR lstrcpy in Win32API ;
		INT_LPTSTR lpString1, ;
		INT_LPCTSTR lpString2
	
	Declare INT_LPTSTR lstrcpyW in Win32API ;
		INT_LPTSTR lpString1, ;
		INT_LPCTSTR lpString2
		
	Declare INT_LPTSTR lstrcpyn in Win32API ;
		INT_LPTSTR lpString1, ;
		INT_LPCTSTR lpString2, ;
		int iMaxLength
		
	Declare INT_LPTSTR lstrcpynW in Win32API ;
		INT_LPTSTR lpString1, ;
		INT_LPCTSTR lpString2, ;
		int iMaxLength
		
	Declare int lstrlen in Win32API ;
		INT_LPCTSTR lpString
	
	Declare int lstrlenW in Win32API ;
		INT_LPCTSTR lpString
	
	