*====================================================================
* This program declares memory related API functions. This covers
* plain memory allocation and file mapping functions. 
*
* Docs: Platform SDK > Base Services > Memory
*
*====================================================================

	#INCLUDE Header\Declare.H
	
	*-----------------------------------------------------------------
	* File mapping functions: object handling
	*-----------------------------------------------------------------
	Declare HANDLE CreateFileMapping in Win32API ;
		HANDLE hFile, ;
		LPSECURITY_ATTRIBUTES lpFileMappingAttributes, ;
		DWORD flProtect, ;
		DWORD dwMaximumSizeHigh, ;
		DWORD dwMaximumSizeLow, ;
		LPCTSTR lpName

	Declare HANDLE OpenFileMapping in Win32API ;
		DWORD dwDesiredAccess, ;
		BOOL bInheritHandle, ;
		LPCTSTR lpName

	*-----------------------------------------------------------------
	* File mapping functions: ViewOfFile functions.
	*-----------------------------------------------------------------
	Declare BOOL FlushViewOfFile in Win32API ;
		LPCVOID lpBaseAddress, ;
		DWORD dwNumberOfBytesToFlush
	
	Declare LPVOID MapViewOfFile in Win32API ;
		HANDLE hFileMappingObject, ;
		DWORD dwDesiredAccess, ;
		DWORD dwFileOffsetHigh, ;
		DWORD dwFileOffsetLow, ;
		DWORD dwNumberOfBytesToMap

	Declare LPVOID MapViewOfFileEx in Win32API ;
		HANDLE hFileMappingObject, ;
		DWORD dwDesiredAccess, ;
		DWORD dwFileOffsetHigh, ;
		DWORD dwFileOffsetLow, ;
		DWORD dwNumberOfBytesToMap, ;
		LPVOID lpBaseAddress
		
	Declare BOOL UnmapViewOfFile in Win32API ;
		LPCVOID lpBaseAddress
	
	*-----------------------------------------------------------------
	* memory functions: Heap operations
	*-----------------------------------------------------------------
	Declare HANDLE GetProcessHeap in Win32API
	
	Declare DWORD GetProcessHeaps in Win32API ;
		DWORD NumberOfHeaps, ;
		PHANDLE ProcessHeaps

	Declare LPVOID HeapAlloc in Win32API ;
		HANDLE hHeap, ;
		DWORD dwFlags, ;
		DWORD dwBytes

	Declare UINT HeapCompact in Win32API ;
		HANDLE hHeap, ;
		DWORD dwFlags

	Declare HANDLE HeapCreate in Win32API ;
		DWORD flOptions, ;
		DWORD dwInitialSize, ;
		DWORD dwMaximumSize

	Declare BOOL HeapDestroy in Win32API ;
		HANDLE hHeap

	Declare BOOL HeapFree in Win32API ;
		HANDLE hHeap, ;
		DWORD dwFlags, ;
		LPVOID lpMem

	Declare BOOL HeapLock in Win32API ;
		HANDLE hHeap

	Declare LPVOID HeapReAlloc in Win32API ;
		HANDLE hHeap, ;
		DWORD dwFlags, ;
		LPVOID lpMem, ;
		DWORD dwBytes

	Declare DWORD HeapSize in Win32API ;
		HANDLE hHeap, ;
		DWORD dwFlags, ;
		LPCVOID lpMem

	Declare BOOL HeapUnlock in Win32API ;
		HANDLE hHeap

	Declare BOOL HeapValidate in Win32API ;
		HANDLE hHeap, ;
		DWORD dwFlags, ;
		LPCVOID lpMem

	Declare BOOL HeapWalk in Win32API ;
		HANDLE hHeap, ;
		LPPROCESS_HEAP_ENTRY lpEntry

	*-----------------------------------------------------------------
	* memory functions: obtaining information
	*-----------------------------------------------------------------
	Declare VOID GlobalMemoryStatus in Win32API ;
		LPMEMORYSTATUS lpBuffer
		
	*-----------------------------------------------------------------
	* memory functions: memory and pointer validation
	*-----------------------------------------------------------------
	Declare BOOL IsBadCodePtr in Win32API ;
		FARPROC lpfn

	Declare BOOL IsBadReadPtr in Win32API ;
		LPVOID lp, ;
		UINT ucb

	Declare BOOL IsBadStringPtr in Win32API ;
		LPCTSTR lpsz, ;
		UINT ucchMax

	Declare BOOL IsBadWritePtr in Win32API ;
		LPVOID lp, ;
		UINT ucb

	*-----------------------------------------------------------------
	* memory functions: virtual memory
	*-----------------------------------------------------------------
	Declare LPVOID VirtualAlloc in Win32API ;
		LPVOID lpAddress, ;
		DWORD dwSize, ;
		DWORD flAllocationType, ;
		DWORD flProtect
		
	Declare BOOL VirtualFree in Win32API ;
		LPVOID lpAddress, ;
		DWORD dwSize, ;
		DWORD dwFreeType

	Declare BOOL VirtualProtect in Win32API ;
		LPVOID lpAddress, ;
		DWORD dwSize, ;
		DWORD flNewProtect, ;
		PDWORD lpflOldProtect
	
	Declare BOOL VirtualProtectEx in Win32API ;
		HANDLE hProcess, ;
		LPVOID lpAddress, ;
		DWORD dwSize, ;
		DWORD flNewProtect, ;
		PDWORD lpflOldProtect

	Declare DWORD VirtualQuery in Win32API ;
		LPCVOID lpAddress, ;
		PMEMORY_BASIC_INFORMATION lpBuffer, ;
		DWORD dwLength

	Declare DWORD VirtualQueryEx in Win32API ;
		HANDLE hProcess, ;
		LPCVOID lpAddress, ;
		PMEMORY_BASIC_INFORMATION lpBuffer, ;
		DWORD dwLength
