*====================================================================
* This program declares file, file system and I/O related API 
* functions. 
*
* Docs: Platform SDK > Base Services > Files and I/O
*
*====================================================================

	#INCLUDE Header\Declare.H
	
	*-----------------------------------------------------------------
	* File I/O functions: Basic file operations
	*-----------------------------------------------------------------
	Declare HANDLE CreateFile in Win32API ;
		LPCTSTR lpFileName, ;
		DWORD dwDesiredAccess, ;
		DWORD dwShareMode, ;
		LPSECURITY_ATTRIBUTES lpSecurityAttributes, ;
		DWORD dwCreationDisposition, ;
		DWORD dwFlagsAndAttributes, ;
		HANDLE hTemplateFile
	
	Declare BOOL DeleteFile in Win32API ;
		LPCTSTR lpFileName

	Declare BOOL FlushFileBuffers in Win32API ;
		HANDLE hFile
		
	Declare DWORD GetFullPathName in Win32API ;
		LPCTSTR lpFileName, ;
		DWORD nBufferLength, ;
		LPTSTR lpBuffer, ;
		INTEGER @lpFilePart
	
*	Declare BOOL ReadFile in Win32API ;
		HANDLE hFile, ;
		STRING @lpBuffer, ;
		DWORD nNumberOfBytesToRead, ;
		LPDWORD lpNumberOfBytesRead, ;
		LPOVERLAPPED lpOverlapped

*	Declare BOOL ReadFileEx in Win32API ;
	  HANDLE hFile, ;
	  LPVOID lpBuffer, ;
	  DWORD nNumberOfBytesToRead, ;
	  LPOVERLAPPED lpOverlapped, ;
	  LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine 

	Declare BOOL SetEndOfFile in Win32API ;
		HANDLE hFile

	Declare DWORD SetFilePointer in Win32API ;
		HANDLE hFile, ;
		LONG lDistanceToMove, ;
		PLONG lpDistanceToMoveHigh, ;
		DWORD dwMoveMethod

*	Declare BOOL WriteFile in Win32API ;
		HANDLE hFile, ;
		STRING lpBuffer, ;
		DWORD nNumberOfBytesToWrite, ;
		LPDWORD lpNumberOfBytesWritten, ;
		LPOVERLAPPED lpOverlapped

*	Declare BOOL WriteFileEx in Win32API ;
		HANDLE hFile, ;
		LPCVOID lpBuffer, ;
		DWORD nNumberOfBytesToWrite, ;
		LPOVERLAPPED lpOverlapped, ;
		LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine  

	*-----------------------------------------------------------------
	* File I/O functions: Finding files
	*-----------------------------------------------------------------
	Declare BOOL FindClose in Win32API ;
		HANDLE hFindFile		

	Declare BOOL FindCloseChangeNotification in Win32API ;
		HANDLE hChangeHandle

	Declare HANDLE FindFirstChangeNotification in Win32API ;
		LPCTSTR lpPathName, ;
		BOOL bWatchSubtree, ;
		DWORD dwNotifyFilter
		
	Declare HANDLE FindFirstFile in Win32API ;
		LPCTSTR lpFileName, ;
		LPWIN32_FIND_DATA lpFindFileData

	Declare BOOL FindNextChangeNotification in Win32API ;
		HANDLE hChangeHandle

	Declare BOOL FindNextFile in Win32API ;
		HANDLE hFindFile, ;
		LPWIN32_FIND_DATA lpFindFileData
		
	Declare DWORD SearchPath in Win32API ;
		LPCTSTR lpPath, ;
		LPCTSTR lpFileName, ;
		LPCTSTR lpExtension, ;
		DWORD nBufferLength, ;
		LPTSTR lpBuffer, ;
		INTEGER @lpFilePart

	*-----------------------------------------------------------------
	* File I/O functions: overlapped I/O operation
	*-----------------------------------------------------------------
	Declare BOOL CancelIo in Win32API ;
		HANDLE hFile
	
	*-----------------------------------------------------------------
	* File I/O functions: copying and moving files
	*-----------------------------------------------------------------
	Declare BOOL CopyFile in Win32API ;
		LPCTSTR lpExistingFileName, ;
		LPCTSTR lpNewFileName, ;
		BOOL bFailIfExists

	Declare BOOL CopyFileEx in Win32API ;
		LPCWSTR lpExistingFileName, ;
		LPCWSTR lpNewFileName, ;
		LPPROGRESS_ROUTINE lpProgressRoutine, ;
		LPVOID lpData, ;
		LPBOOL pbCancel, ;
		DWORD dwCopyFlags

	Declare BOOL MoveFile in Win32API ;
		LPCTSTR lpExistingFileName, ;
		LPCTSTR lpNewFileName

	*-----------------------------------------------------------------
	* File I/O functions: directories
	*-----------------------------------------------------------------
	Declare BOOL CreateDirectory in Win32API ;
		LPCTSTR lpPathName, ;
		LPSECURITY_ATTRIBUTES lpSecurityAttributes

	Declare BOOL CreateDirectoryEx in Win32API ;
		LPCTSTR lpTemplateDirectory, ;
		LPCTSTR lpNewDirectory, ;
		LPSECURITY_ATTRIBUTES lpSecurityAttributes
	
	Declare DWORD GetCurrentDirectory in Win32API ;
		DWORD nBufferLength, ;
		LPTSTR lpBuffer

	Declare BOOL RemoveDirectory in Win32API ;
		LPCTSTR lpPathName

	Declare BOOL SetCurrentDirectory in Win32API ;
		LPCTSTR lpPathName

	*-----------------------------------------------------------------
	* File I/O functions: disk/drive/volume operations and querying 
	*                     information
	*-----------------------------------------------------------------
	Declare BOOL GetDiskFreeSpace in Win32API ;
		LPCTSTR lpRootPathName, ;
		LPDWORD lpSectorsPerCluster, ;
		LPDWORD lpBytesPerSector, ;
		LPDWORD lpNumberOfFreeClusters, ;
		LPDWORD lpTotalNumberOfClusters

	Declare BOOL GetDiskFreeSpaceEx in Win32API ;
		LPCTSTR lpDirectoryName, ;
		PULARGE_INTEGER lpFreeBytesAvailableToCaller, ;
		PULARGE_INTEGER lpTotalNumberOfBytes, ;
		PULARGE_INTEGER lpTotalNumberOfFreeBytes

	Declare UINT GetDriveType in Win32API ;
		LPCTSTR lpRootPathName
		
	Declare DWORD GetLogicalDrives in Win32API
	
	Declare DWORD GetLogicalDriveStrings in Win32API ;
		DWORD nBufferLength, ;
		LPTSTR lpBuffer

	Declare BOOL SetVolumeLabel in Win32API ;
		LPCTSTR lpRootPathName, ;
		LPCTSTR lpVolumeName

	*-----------------------------------------------------------------
	* File I/O functions: file attributes
	*-----------------------------------------------------------------
	Declare DWORD GetFileAttributes in Win32API ;
		LPCTSTR lpFileName
	
	Declare BOOL GetFileAttributesEx in Win32API ;
		LPCTSTR lpFileName, ;
		GET_FILEEX_INFO_LEVELS fInfoLevelId, ;
		STRING @lpFileInformation

	Declare BOOL SetFileAttributes in Win32API ;
		LPCTSTR lpFileName, ;
		DWORD dwFileAttributes

	*-----------------------------------------------------------------
	* File I/O function: file information
	*-----------------------------------------------------------------
	Declare BOOL GetFileInformationByHandle in Win32API ;
		HANDLE hFile, ;
		LPBY_HANDLE_FILE_INFORMATION lpFileInformation

	Declare DWORD GetFileSize in Win32API ;
		HANDLE hFile, ;
		LPDWORD lpFileSizeHigh
	
	Declare DWORD GetFileType in Win32API ;
		HANDLE hFile
	
	*-----------------------------------------------------------------
	* File I/O functions: file and path names
	*-----------------------------------------------------------------
	Declare DWORD GetLongPathName in Win32API ;
		LPCTSTR lpszShortPath, ;
		LPTSTR lpszLongPath, ;
		DWORD cchBuffer

	Declare DWORD GetShortPathName in Win32API ;
		LPCTSTR lpszLongPath, ;
		LPTSTR lpszShortPath, ;
		DWORD cchBuffer
	
	*-----------------------------------------------------------------
	* File I/O functions: temporary files
	*-----------------------------------------------------------------
	Declare UINT GetTempFileName in Win32API ;
		LPCTSTR lpPathName, ;
		LPCTSTR lpPrefixString, ;
		UINT uUnique, ;
		LPTSTR lpTempFileName 

	Declare DWORD GetTempPath in Win32API ;
		DWORD nBufferLength, ;
		LPTSTR lpBuffer

	*-----------------------------------------------------------------
	* File I/O functions: locking
	*-----------------------------------------------------------------
	Declare BOOL LockFile in Win32API ;
		HANDLE hFile, ;
		DWORD dwFileOffsetLow, ;
		DWORD dwFileOffsetHigh, ;
		DWORD nNumberOfBytesToLockLow, ;
		DWORD nNumberOfBytesToLockHigh

	Declare BOOL UnlockFile in Win32API ;
		HANDLE hFile, ;
		DWORD dwFileOffsetLow, ;
		DWORD dwFileOffsetHigh, ;
		DWORD nNumberOfBytesToUnlockLow, ;
		DWORD nNumberOfBytesToUnlockHigh 

 	*-----------------------------------------------------------------
	* File I/O functions: large integer operations
	*-----------------------------------------------------------------
	Declare Integer MulDiv in Win32API ;
		Integer nNumber, ;
		Integer nNumerator, ;
		Integer nDenominator

