*====================================================================
* This procedure file contains additional functions that can be used
* for API programming. 
*
* written by The Foxpert!, 1999. Placed into Public Domain.
* 
*====================================================================


*====================================================================
* This function receives a reference to a form and returns the HWND
* (window handle) of this window. This lets you call all functions
* that require such a handle.
*====================================================================
Procedure APIGetHWND
LParameter toForm

	*-----------------------------------------------------------------
	* We identify a form with its caption. In order to get an exact
	* match we temporarily change the form's caption.
	*-----------------------------------------------------------------
	Local lcCaption
	lcCaption = toForm.Caption
	toForm.Caption = Sys(3)
	
	*-----------------------------------------------------------------
	* Getting the window handle is part of a FoxTools function.
	*-----------------------------------------------------------------
	If not "FOXTOOLS" $ Upper( Set("Library") )
		Set Library to (Home()+"\FoxTools.Fll") Additive
	Endif
	
	*-----------------------------------------------------------------
	* Get the HWND window handle
	*-----------------------------------------------------------------
	Local lnHWND
	lnHWND = _WhToHwnd( _WFindTitl(toForm.Caption) )
	
	*-----------------------------------------------------------------
	* Restore previous caption
	*-----------------------------------------------------------------
	toForm.Caption = m.lcCaption	
	
Return m.lnHWND


*====================================================================
* Converts a signed 32-bit integer into an unsigned 32-bit integer
* value. From their binary representation negative values and 
* positive values are the same, it's actually a matter of interpre-
* tation how the values are treated. For example, 0xFFFF can be -1
* as well as 65535. 
* When you call an API function and pass a positive value that
* excedes the range of signed values, VFP automatically treats it as
* a negative value. For the API function, it doesn't matter. The
* problem is with return values. VFP always treats them as signed
* integers, therefore 0xFFFFFFFF (a 32-bit value) is returned as
* -1. But if you use a constant like 0xFFFFFFFF to compare the return
* value (in case of an error, for example), both won't match.
* This function takes a negative 32-bit value (or a positive one) and
* converts it into an unsigned integer.
*====================================================================
Procedure APIMakeUINT
LParameter tnSignedInt

	Local lnUnsigned
	If m.tnSignedInt < 0
		lnUnsigned = m.tnSignedInt + 2^32
	Else
		lnUnsigned = m.tnSignedInt
	Endif
	
Return m.lnUnsigned


*====================================================================
* Returns the address of a VFP string. Be carefull with this #
* function, because VFP moves strings around in memory and the 
* address returned by this function might not be valid. For safety,
* you should allocate memory and copy the string to memory.
* The string must be passed by reference!
*====================================================================
Procedure APIAddressOfString
LParameter tcString

	* (...) 

Return m.lnAddress