*====================================================================
* This include file converts API declaration types to those 
* declarations used in Visual FoxPro's DECLARE-DLL command. 
*
* NOTE: You can't always use the same data types in VFP that are
*       used in the API declaration. There are numerous reasons.
*       One reason is that sometimes the way you call an API function
*       differes from the declaration, for example when structure
*       buffers are involved. Another reason is that return values
*       are treated differently.
*
* Written 1999 by Christof Lange, The Foxpert!
* Placed into Public Domain.
*====================================================================

	*-----------------------------------------------------------------
	* simple data types. These types can be used as a parameter as 
	* well as for return values.
	*-----------------------------------------------------------------
	#DEFINE BOOL                                  INTEGER
	#DEFINE BYTE                                  SHORT
	#DEFINE DWORD                                 INTEGER
	#DEFINE INT                                   INTEGER
	#DEFINE LCID                                  INTEGER
	#DEFINE LPCTSTR                               STRING
	#DEFINE TCHAR                                 SHORT
	#DEFINE WORD                                  SHORT
	
	*-----------------------------------------------------------------
	* simple data types. These types can be used as parameters and
	* as return values. When you use these types for return values or
	* parameters that are passed by reference, you have to call some
	* additional functions, because VFP doesn't natively support
	* unsigned integers. They appear as negative values which might
	* cause problems if you use constants that expect positive values.
	* Calling a function is no problem, because VFP automatically 
	* converts the value to a negative number.
	*-----------------------------------------------------------------
	#DEFINE UINT                                  INTEGER
	
	*-----------------------------------------------------------------
	* Handles. Windows uses a lot of handles for almost every aspect
	* of Windows. Technically, a handle is a pointer to some unknown
	* memory, but in practice, only the operating system accesses that
	* memory and you can see it as a plain integer.
	*-----------------------------------------------------------------
	#DEFINE HANDLE                                INTEGER
	#DEFINE HFILE                                 INTEGER
	#DEFINE HICON                                 INTEGER
	#DEFINE HINSTANCE                             INTEGER
	#DEFINE HWND                                  INTEGER
	
	*-----------------------------------------------------------------
	* simple data types. Since these parameters are all passed by
	* reference, you can only use them in the parameter list of the
	* DECLARE-DLL command.
	*-----------------------------------------------------------------
	#DEFINE LPBOOL                                INTEGER @
	#DEFINE LPDWORD                               INTEGER @
	#DEFINE LPLONG                                LONG @
	#DEFINE LPTSTR                                STRING @
	#DEFINE LPWORD                                INTEGER @
	#DEFINE PDWORD                                INTEGER @
	#DEFINE PLONG                                 LONG @
	
	*-----------------------------------------------------------------
	* simple unicode data types. Since these parameters are all 
	* passed by  reference, you can only use them in the parameter 
	* list of the DECLARE-DLL command. To pass these parameters from
	* and to VFP, you have to use STRCONV() to convert strings to 
	* Unicode. And all strings must be terminated with an additional
	* CHR(0).
	*-----------------------------------------------------------------
	#DEFINE LPCWSTR                               STRING
	
	*-----------------------------------------------------------------
	* The following data types can either be Unicode or ANSI. These
	* data types can be used on both sides of the DECLARE DLL command,
	* as they describe constant strings. There's one exception, 
	* though. If it's used for the return value, the string must be 
	* ANSI, because otherwise VFP would recognize the first CHR(0) as
	* a terminating character although it's actually part of the first
	* character.
	*-----------------------------------------------------------------
	#DEFINE LPCSTR                                STRING
	
	*-----------------------------------------------------------------
	* simple data types. The following types may contain unicode as 
	* well as ANSI values. SInce they are passed by reference, you can
	* only use them in the parameter list of the DECLARE-DLL command.
	*-----------------------------------------------------------------
	#DEFINE LPSTR                                 STRING @
	
	*-----------------------------------------------------------------
	* string pointer data types for memory handling. These data types
	* match the string data types, but are meant for strings in 
	* memory, not for VFP strings. Therefore they all contain the
	* address of a string and therefore are numeric.
	* You can use the APIAddressOfString() function to determine the
	* address of a VFP string. Those strings must contains a CHR(0) at
	* the end.
	*-----------------------------------------------------------------
	#DEFINE INT_LPCTSTR                           INTEGER
	#DEFINE INT_LPTSTR                            INTEGER
	#DEFINE INT_LPSTR                             INTEGER
	#DEFINE INT_LPCSTR                            INTEGER
	
	*-----------------------------------------------------------------
	* Null data types. These are usually used as return values when
	* a function doesn't return anything.
	*-----------------------------------------------------------------
	#DEFINE VOID
	
	*-----------------------------------------------------------------
	* Pointer to structures. Many of them can be found in the 
	* WinStruct.VCX file.
	*-----------------------------------------------------------------
	#DEFINE LPBY_HANDLE_FILE_INFORMATION          STRING @
	#DEFINE LPMEMORYSTATUS                        STRING @
	#DEFINE LPOVERLAPPED                          STRING @
	#DEFINE LPPROCESS_HEAP_ENTRY                  STRING @
	#DEFINE LPSECURITY_ATTRIBUTES                 STRING @
	#DEFINE LPWIN32_FIND_DATA                     STRING @
	#DEFINE PFLASHWINFO                           STRING @
	#DEFINE PHANDLE                               STRING @
	#DEFINE PLARGE_INTEGER                        STRING @
	#DEFINE PMEMORY_BASIC_INFORMATION             STRING @
	#DEFINE PULARGE_INTEGER                       STRING @
	
	*-----------------------------------------------------------------
	* complex memory pointers. These pointers are integers that hold
	* the address of a memory block. You have to use memory functions
	* to access this block. Pass the variable for the memory address.
	* If you pass this parameter by refernce to receive a return 
	* value, you have to add "@" to the variable.
	*-----------------------------------------------------------------	
	#DEFINE LPCVOID                               INTEGER
	#DEFINE LPVOID                                INTEGER
	#DEFINE PVOID                                 INTEGER
	
	*-----------------------------------------------------------------
	* procedure addresses. You can't pass a reference to a VFP 
	* procedure here.
	*-----------------------------------------------------------------
	#DEFINE FARPROC                               INTEGER
	#DEFINE LPOVERLAPPED_COMPLETION_ROUTINE       INTEGER
	#DEFINE LPPROGRESS_ROUTINE                    INTEGER
	
	*-----------------------------------------------------------------
	* Enumerations. Enumerations are like constants in VFP, but the
	* value the have depends on their position in the enumeration. In
	* C++ the have the additional advantage of not being global. That
	* means, the same name can be used for different values in 
	* different enumerations. In VFP we simulate this with a number of
	* #DEFINEs. All enumeration start with _ENUM_ followed by the name
	* used in Windows. If the name is not unique, the name of the 
	* enumeration is added to the entire name separated by an under-
	* score character.
	*-----------------------------------------------------------------
	#DEFINE GET_FILEEX_INFO_LEVELS                INTEGER
	
	*-----------------------------------------------------------------
	* Enumeration: GET_FILEEX_INFO_LEVELS
	*-----------------------------------------------------------------
	#DEFINE _ENUM_GetFileExInfoStandard                              0
	
	*-----------------------------------------------------------------
	* Multimedia data types. Usually used in WinMM.Dll
	*-----------------------------------------------------------------
	#DEFINE MMRESULT                              INTEGER