	*-----------------------------------------------------------------
	* Device Parameters for GetDeviceCaps()
	*-----------------------------------------------------------------
	#DEFINE DRIVERVERSION 0     && Device driver version
	#DEFINE TECHNOLOGY    2     && Device classification
	#DEFINE HORZSIZE      4     && Horizontal size in millimeters
	#DEFINE VERTSIZE      6     && Vertical size in millimeters
	#DEFINE HORZRES       8     && Horizontal width in pixels
	#DEFINE VERTRES       10    && Vertical height in pixels
	#DEFINE BITSPIXEL     12    && Number of bits per pixel
	#DEFINE PLANES        14    && Number of planes
	#DEFINE NUMBRUSHES    16    && Number of brushes the device has
	#DEFINE NUMPENS       18    && Number of pens the device has
	#DEFINE NUMMARKERS    20    && Number of markers the device has
	#DEFINE NUMFONTS      22    && Number of fonts the device has
	#DEFINE NUMCOLORS     24    && Number of colors the device supports
	#DEFINE PDEVICESIZE   26    && Size required for device descriptor
	#DEFINE CURVECAPS     28    && Curve capabilities
	#DEFINE LINECAPS      30    && Line capabilities
	#DEFINE POLYGONALCAPS 32    && Polygonal capabilities
	#DEFINE TEXTCAPS      34    && Text capabilities
	#DEFINE CLIPCAPS      36    && Clipping capabilities
	#DEFINE RASTERCAPS    38    && Bitblt capabilities
	#DEFINE ASPECTX       40    && Length of the X leg
	#DEFINE ASPECTY       42    && Length of the Y leg
	#DEFINE ASPECTXY      44    && Length of the hypotenuse
	#DEFINE SHADEBLENDCAPS 45   && Shading and blending caps
	#DEFINE LOGPIXELSX    88    && Logical pixels/inch in X
	#DEFINE LOGPIXELSY    90    && Logical pixels/inch in Y
	#DEFINE SIZEPALETTE  104    && Number of entries in physical palette
	#DEFINE NUMRESERVED  106    && Number of reserved entries in palette
	#DEFINE COLORRES     108    && Actual color resolution
	#DEFINE PHYSICALWIDTH   110 && Physical Width in device units
	#DEFINE PHYSICALHEIGHT  111 && Physical Height in device units
	#DEFINE PHYSICALOFFSETX 112 && Physical Printable Area x margin
	#DEFINE PHYSICALOFFSETY 113 && Physical Printable Area y margin
	#DEFINE SCALINGFACTORX  114 && Scaling factor x
	#DEFINE SCALINGFACTORY  115 && Scaling factor y
	#DEFINE VREFRESH        116 && Current vertical refresh rate of the
	                            && display device (for displays only) in Hz
	#DEFINE DESKTOPVERTRES  117 && Horizontal width of entire desktop in
	                            && pixels
	#DEFINE DESKTOPHORZRES  118 && Vertical height of entire desktop in
	                            && pixels
	#DEFINE BLTALIGNMENT    119 && Preferred blt alignment

	*-----------------------------------------------------------------
	* Background Modes
	*-----------------------------------------------------------------
	#DEFINE TRANSPARENT         1
	#DEFINE OPAQUE              2
	
	*-----------------------------------------------------------------
	* Constants for EnumDisplaySettings()
	*-----------------------------------------------------------------
	#DEFINE ENUM_CURRENT_SETTINGS       -1
	#DEFINE ENUM_REGISTRY_SETTINGS      -2

	*-----------------------------------------------------------------
	* DEVMODE structure: field selection bits (dmFields)
	*-----------------------------------------------------------------
	#DEFINE DM_ORIENTATION                                  0x00000001
	#DEFINE DM_PAPERSIZE                                    0x00000002
	#DEFINE DM_PAPERLENGTH                                  0x00000004
	#DEFINE DM_PAPERWIDTH                                   0x00000008
	#DEFINE DM_SCALE                                        0x00000010
	#DEFINE DM_POSITION                                     0x00000020
	#DEFINE DM_COPIES                                       0x00000100
	#DEFINE DM_DEFAULTSOURCE                                0x00000200
	#DEFINE DM_PRINTQUALITY                                 0x00000400
	#DEFINE DM_COLOR                                        0x00000800
	#DEFINE DM_DUPLEX                                       0x00001000
	#DEFINE DM_YRESOLUTION                                  0x00002000
	#DEFINE DM_TTOPTION                                     0x00004000
	#DEFINE DM_COLLATE                                      0x00008000
	#DEFINE DM_FORMNAME                                     0x00010000
	#DEFINE DM_LOGPIXELS                                    0x00020000
	#DEFINE DM_BITSPERPEL                                   0x00040000
	#DEFINE DM_PELSWIDTH                                    0x00080000
	#DEFINE DM_PELSHEIGHT                                   0x00100000
	#DEFINE DM_DISPLAYFLAGS                                 0x00200000
	#DEFINE DM_DISPLAYFREQUENCY                             0x00400000
	#DEFINE DM_ICMMETHOD                                    0x00800000
	#DEFINE DM_ICMINTENT                                    0x01000000
	#DEFINE DM_MEDIATYPE                                    0x02000000
	#DEFINE DM_DITHERTYPE                                   0x04000000
	#DEFINE DM_PANNINGWIDTH                                 0x08000000
	#DEFINE DM_PANNINGHEIGHT                                0x10000000

	*-----------------------------------------------------------------
	* dwInfoLevel parameter for WNetGetUniversalName()
	*-----------------------------------------------------------------
	#DEFINE UNIVERSAL_NAME_INFO_LEVEL   	                 0x00000001
	#DEFINE REMOTE_NAME_INFO_LEVEL      	                 0x00000002

	*-----------------------------------------------------------------
	* Error values returned by WNetGetUniversalName()
	*-----------------------------------------------------------------
	#DEFINE ERROR_BAD_DEVICE                1200
	#DEFINE ERROR_CONNECTION_UNAVAIL        1201
	#DEFINE ERROR_EXTENDED_ERROR            1208
	#DEFINE ERROR_MORE_DATA                  234
	#DEFINE ERROR_NOT_SUPPORTED               50
	#DEFINE ERROR_NO_NET_OR_BAD_PATH        1203
	#DEFINE ERROR_NO_NETWORK                2138
	#DEFINE ERROR_NOT_CONNECTED             2250
	#DEFINE ERROR_INVALID_ADDRESS            487
	
	*-----------------------------------------------------------------
	* Return values of wait functions.
	*-----------------------------------------------------------------
	#DEFINE WAIT_FAILED                                     0xFFFFFFFF
	#DEFINE WAIT_OBJECT_0                                   0x00000000
	#DEFINE WAIT_ABANDONED                                  0x00000080
	#DEFINE WAIT_TIMEOUT                                    0x00000102
	#DEFINE IGNORE                                          0x00000000
	#DEFINE INFINITE                                        0xFFFFFFFF
	
	*-----------------------------------------------------------------
	* Values for invalid values
	*-----------------------------------------------------------------
	#DEFINE INVALID_HANDLE_VALUE                            0xFFFFFFFF
	#DEFINE INVALID_FILE_SIZE                               0xFFFFFFFF
	#DEFINE TIME_ZONE_ID_INVALID                            0xFFFFFFFF
	
	*-----------------------------------------------------------------
	* Memory access flags
	*-----------------------------------------------------------------
	#DEFINE PAGE_NOACCESS                                   0x00000001
	#DEFINE PAGE_READONLY                                   0x00000002
	#DEFINE PAGE_READWRITE                                  0x00000004
	#DEFINE PAGE_WRITECOPY                                  0x00000008
	#DEFINE PAGE_EXECUTE                                    0x00000010
	#DEFINE PAGE_EXECUTE_READ                               0x00000020
	#DEFINE PAGE_EXECUTE_READWRITE                          0x00000040
	#DEFINE PAGE_EXECUTE_WRITECOPY                          0x00000080
	#DEFINE PAGE_GUARD                                      0x00000100
	#DEFINE PAGE_NOCACHE                                    0x00000200
	#DEFINE PAGE_WRITECOMBINE                               0x00000400
	#DEFINE MEM_COMMIT                                      0x00001000
	#DEFINE MEM_RESERVE                                     0x00002000
	#DEFINE MEM_DECOMMIT                                    0x00004000
	#DEFINE MEM_RELEASE                                     0x00008000
	#DEFINE MEM_FREE                                        0x00010000
	#DEFINE MEM_PRIVATE                                     0x00020000
	#DEFINE MEM_MAPPED                                      0x00040000
	#DEFINE MEM_RESET                                       0x00080000
	#DEFINE MEM_TOP_DOWN                                    0x00100000
	#DEFINE MEM_4MB_PAGES                                   0x80000000
	#DEFINE SEC_FILE                                        0x00800000
	#DEFINE SEC_IMAGE                                       0x01000000
	#DEFINE SEC_VLM                                         0x02000000
	#DEFINE SEC_RESERVE                                     0x04000000
	#DEFINE SEC_COMMIT                                      0x08000000
	#DEFINE SEC_NOCACHE                                     0x10000000
	#DEFINE MEM_IMAGE                                        SEC_IMAGE

	#DEFINE SECTION_QUERY                                   0x00000001
	#DEFINE SECTION_MAP_WRITE                               0x00000002
	#DEFINE SECTION_MAP_READ                                0x00000004
	#DEFINE SECTION_MAP_EXECUTE                             0x00000008
	#DEFINE SECTION_EXTEND_SIZE                             0x00000010

	#DEFINE STANDARD_RIGHTS_REQUIRED                        0x000F0000
	
	#DEFINE SECTION_ALL_ACCESS           (STANDARD_RIGHTS_REQUIRED + ;
	                                      SECTION_QUERY + ;
                                         SECTION_MAP_WRITE + ;
                                         SECTION_MAP_READ + ;
                                         SECTION_MAP_EXECUTE + ;
                                         SECTION_EXTEND_SIZE)

	*-----------------------------------------------------------------
	* Access flags for views of files in a file mapping object. These
	* values are used in the CreateViewOfFile() function.
	*-----------------------------------------------------------------
	#DEFINE FILE_MAP_COPY       SECTION_QUERY
	#DEFINE FILE_MAP_WRITE      SECTION_MAP_WRITE
	#DEFINE FILE_MAP_READ       SECTION_MAP_READ
	#DEFINE FILE_MAP_ALL_ACCESS SECTION_ALL_ACCESS
	
	*-----------------------------------------------------------------
	* generic rights
	*-----------------------------------------------------------------
	#DEFINE GENERIC_READ                                    0x80000000
	#DEFINE GENERIC_WRITE                                   0x40000000
	#DEFINE GENERIC_EXECUTE                                 0x20000000
	#DEFINE GENERIC_ALL                                     0x10000000
	
	*-----------------------------------------------------------------
	* Options for the dwShareMode parameter of CreateFile()
	*-----------------------------------------------------------------
	#DEFINE FILE_SHARE_READ                                 0x00000001
	#DEFINE FILE_SHARE_WRITE                                0x00000002
	#DEFINE FILE_SHARE_DELETE                               0x00000004
	
	*-----------------------------------------------------------------
	* Options for the dwCreationDisposition of CreateFile()
	*-----------------------------------------------------------------
	#DEFINE CREATE_NEW                                               1
	#DEFINE CREATE_ALWAYS                                            2
	#DEFINE OPEN_EXISTING                                            3
	#DEFINE OPEN_ALWAYS                                              4
	#DEFINE TRUNCATE_EXISTING                                        5

	*-----------------------------------------------------------------
	* file attributes
	*-----------------------------------------------------------------
	#DEFINE FILE_ATTRIBUTE_READONLY                         0x00000001  
	#DEFINE FILE_ATTRIBUTE_HIDDEN                           0x00000002  
	#DEFINE FILE_ATTRIBUTE_SYSTEM                           0x00000004  
	#DEFINE FILE_ATTRIBUTE_DIRECTORY                        0x00000010  
	#DEFINE FILE_ATTRIBUTE_ARCHIVE                          0x00000020  
	#DEFINE FILE_ATTRIBUTE_ENCRYPTED                        0x00000040  
	#DEFINE FILE_ATTRIBUTE_NORMAL                           0x00000080  
	#DEFINE FILE_ATTRIBUTE_TEMPORARY                        0x00000100  
	#DEFINE FILE_ATTRIBUTE_SPARSE_FILE                      0x00000200  
	#DEFINE FILE_ATTRIBUTE_REPARSE_POINT                    0x00000400  
	#DEFINE FILE_ATTRIBUTE_COMPRESSED                       0x00000800  
	#DEFINE FILE_ATTRIBUTE_OFFLINE                          0x00001000  
	#DEFINE FILE_ATTRIBUTE_NOT_CONTENT_INDEXED              0x00002000  
	
	*-----------------------------------------------------------------
	* file creation flags for the dwFlagsAndAttributes parameter
	* of the CreateFile() function.
	*-----------------------------------------------------------------
	#DEFINE FILE_FLAG_WRITE_THROUGH                         0x80000000
	#DEFINE FILE_FLAG_OVERLAPPED                            0x40000000
	#DEFINE FILE_FLAG_NO_BUFFERING                          0x20000000
	#DEFINE FILE_FLAG_RANDOM_ACCESS                         0x10000000
	#DEFINE FILE_FLAG_SEQUENTIAL_SCAN                       0x08000000
	#DEFINE FILE_FLAG_DELETE_ON_CLOSE                       0x04000000
	#DEFINE FILE_FLAG_BACKUP_SEMANTICS                      0x02000000
	#DEFINE FILE_FLAG_POSIX_SEMANTICS                       0x01000000
	#DEFINE FILE_FLAG_OPEN_REPARSE_POINT                    0x00200000
	#DEFINE FILE_FLAG_OPEN_NO_RECALL                        0x00100000
	
	*-----------------------------------------------------------------
	* Heap flags used in numerous heap functions.
	*-----------------------------------------------------------------
	#DEFINE HEAP_NO_SERIALIZE                               0x00000001
	#DEFINE HEAP_GROWABLE                                   0x00000002
	#DEFINE HEAP_GENERATE_EXCEPTIONS                        0x00000004
	#DEFINE HEAP_ZERO_MEMORY                                0x00000008
	#DEFINE HEAP_REALLOC_IN_PLACE_ONLY                      0x00000010
	#DEFINE HEAP_TAIL_CHECKING_ENABLED                      0x00000020
	#DEFINE HEAP_FREE_CHECKING_ENABLED                      0x00000040
	#DEFINE HEAP_DISABLE_COALESCE_ON_FREE                   0x00000080
	#DEFINE HEAP_CREATE_ALIGN_16                            0x00010000
	#DEFINE HEAP_CREATE_ENABLE_TRACING                      0x00020000
	#DEFINE HEAP_MAXIMUM_TAG                                0x00000FFF
	#DEFINE HEAP_PSEUDO_TAG_FLAG                            0x00008000

	*-----------------------------------------------------------------
	* SHAddToRecentDocs(), uFlags parameter
	*-----------------------------------------------------------------
	#DEFINE SHARD_PIDL                                      0x00000001
	#DEFINE SHARD_PATHA                                     0x00000002
	#DEFINE SHARD_PATHW                                     0x00000003
	#DEFINE SHARD_PATH                                     SHARD_PATHA
	
	*-----------------------------------------------------------------
	* 
	*-----------------------------------------------------------------
	#DEFINE SND_SYNC                                        0x00000000
	#DEFINE SND_ASYNC                                       0x00000001
	#DEFINE SND_NODEFAULT                                   0x00000002
	#DEFINE SND_MEMORY                                      0x00000004
	#DEFINE SND_LOOP                                        0x00000008
	#DEFINE SND_NOSTOP                                      0x00000010
	#DEFINE SND_NOWAIT	                                   0x00002000
	#DEFINE SND_ALIAS                                       0x00010000
	#DEFINE SND_ALIAS_ID	                                   0x00110000
	#DEFINE SND_FILENAME                                    0x00020000
	#DEFINE SND_RESOURCE                                    0x00040004
	
	*-----------------------------------------------------------------
	* Resourcetypes
	*-----------------------------------------------------------------
	#DEFINE RESOURCETYPE_DISK                               0x00000001
	