Define Class Server6 as Session OLEPUBLIC
	
	Procedure Init
		Local lcDatabase
		If _VFP.Startmode = 3
			lcDatabase = Addbs(JustPath(_VFP.ServerName)) + "Northwind\Northwind.dbc"
		Else
			lcDatabase = Addbs(_Samples)+"Northwind\Northwind.dbc"
		EndIf
		Open Database (m.lcDatabase)
	EndProc
	
	Procedure GetOrdersOfCustomer(toCallback)
	
		*--------------------------------------------------------------------------------------
		* Das Ermitteln der Daten dauert eine gewisse Zeit
		*--------------------------------------------------------------------------------------
		Declare Sleep in Win32API Long
		Sleep( 500 )
		
		*--------------------------------------------------------------------------------------
		* Abfrage ausfhren
		*--------------------------------------------------------------------------------------
		Local lcID
		lcID = toCallBack.CustomerID
		Select ;
				Orders.OrderID, ;
				Orders.OrderDate, ;
				OrderDetails.UnitPrice*OrderDetails.Quantity as LineTotal, ;
				Products.Productname ;
			From Orders ;
				Join OrderDetails ;
					Join Products ;
					on OrderDetails.Productid == Products.ProductID ;
				on Orders.OrderID == OrderDetails.Orderid ;
			Where Orders.CustomerID == m.lcID ;
			Order by Orders.OrderID ;
			into cursor curOrders
		
		*--------------------------------------------------------------------------------------
		* HTML Ansicht generieren
		*--------------------------------------------------------------------------------------
		Local lcHTML, lnLastOrder
		lcHTML = [<html><body><table width="95%">]
		lnLastOrder = 0
		Scan
			If OrderID # m.lnLastOrder
				lcHTML = m.lcHTML + ;
					[<tr><td colspan="2" bgcolor="#E0FFE0">Rechnung ]+Transform(OrderID)+ ;
					[ vom ]+Transform(OrderDate)+[</td></tr>]
				lnLastOrder = OrderID
			EndIf
			m.lcHTML = m.lcHTML + ;
				[<tr><td>]+ProductName+[</td><td>]+Transform(LineTotal)+[</td></tr>]
		EndScan
		lcHTML = m.lcHTML + [</table></body></html>]
		
		*--------------------------------------------------------------------------------------
		* Die generierte HTML Ansicht zurckgeben
		*--------------------------------------------------------------------------------------
		toCallback.HTML( m.lcHTML )
		
	EndProc

EndDefine