// include files and global variables
	#include "pro_Ext.h"
	#include <windows.h>
	WNDPROC lpPrevWndProc = NULL;
	HWND hwnd = NULL;

// Callback function to handle events
 LRESULT CALLBACK WindowProc(
  HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam ) 
{
	switch( uMsg ) {
	case WM_ACTIVATEAPP:
		if (wParam)
			_Execute("goForm.AppActivate()");
		else
			_Execute("goForm.AppDeactivate()");
		break;
	}
	return CallWindowProc(
		lpPrevWndProc,hwnd,uMsg,wParam,lParam 
	);
};

// CALLONLOAD: hook into window procedure
void onload( ParamBlk *Param )
{
	Value val;
	_Evaluate( &val, "goForm.Hwnd" );
	hwnd = (HWND) val.ev_long;
	lpPrevWndProc = (WNDPROC) SetWindowLong(
		hwnd, GWL_WNDPROC, (LONG) WindowProc 
	);
}

// CALLONUNLOAD: clean up hooks
void onunload( ParamBlk *Param )
{
	SetWindowLong( 
		hwnd, GWL_WNDPROC, (LONG) lpPrevWndProc 
	);
}

// Define all functions of this FLL
FoxInfo myFoxInfo[] = {
	{"LOAD", (FPFI) onload, CALLONLOAD, "" },
	{"UNLOAD", (FPFI) onunload, CALLONUNLOAD, "" }
};

// Is used by VFP internally
extern "C" {
	FoxTable _FoxTable = {
		(FoxTable FAR *) 0, 
		sizeof(myFoxInfo) / sizeof(FoxInfo), 
		myFoxInfo
	};
}

